#! /usr/bin/env python

from openturns import *
from math import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try : 
    sample = NumericalSample(4, 3)
    sample[0][0] = 1
    sample[0][1] = 0
    sample[0][2] = 9
    sample[1][0] = 2
    sample[1][1] = 3
    sample[1][2] = 5
    sample[2][0] = 5
    sample[2][1] = 1
    sample[2][2] = 8
    sample[3][0] = 6
    sample[3][1] = 7
    sample[3][2] = 2

    print "sample=" , sample 
    print "min=" , sample.getMin() 
    print "max=" , sample.getMax()
    print "mean=" , sample.computeMean()
    print "covariance=" , sample.computeCovariance()
    print "standard deviation=" , sample.computeStandardDeviation()
    print "standard deviation per component=" , sample.computeStandardDeviationPerComponent()
    print "Pearson correlation=" , sample.computePearsonCorrelation()
    print "Spearman correlation=" , sample.computeSpearmanCorrelation()
    print "Kendall tau=" , sample.computeKendallTau()
    print "range per component=" , sample.computeRangePerComponent()
    print "median per component=" , sample.computeMedianPerComponent()
    print "Variance=" , sample.computeVariancePerComponent()
    print "Skewness=" , sample.computeSkewnessPerComponent()
    print "Kurtosis=" , sample.computeKurtosisPerComponent()
    print "Marginal 1=" , sample.getMarginal(1)
    indices = Indices(2)
    indices[0] = 2
    indices[1] = 0
    print "Marginal [2, 0]=" , sample.getMarginal(indices)
    prob = 0.25
    print "Quantile per component(" , prob , ")=" , sample.computeQuantilePerComponent(prob) 
    pointCDF = NumericalPoint(sample.getDimension(), 0.25)
    print "Empirical CDF(" , pointCDF , "=" , sample.computeEmpiricalCDF(pointCDF) 
    dim = 3
    R = CorrelationMatrix(dim)
    for i in range(1,dim) :
	R[i, i - 1] = 0.25
    Rtmp = CorrelationMatrix(dim)
    for i in range(dim) :
      for j in range(i) :
	    Rtmp[i, j] = 6.0 * asin(R[i, j] / 2.0) / pi
    print "Pearson correlation (exact)=" , R 
    print "Spearman correlation (exact)=" , Rtmp 
    size = 10000
    normal = Normal(NumericalPoint(dim, 0.0), NumericalPoint(dim, 1.0), R)
    print "Normal=" , normal 
    print "covariance=" , normal.getCovariance() 
    normalSample = normal.getNumericalSample(size)
    print "Empirical covariance=" , normalSample.computeCovariance() 
    RPearson = normalSample.computePearsonCorrelation()
    print "Pearson correlation=" , RPearson 
    RSpearman = normalSample.computeSpearmanCorrelation()
    print "Spearman correlation=" , RSpearman 
#except TestFailed, ex :
except :
  import sys
  print "t_NumericalSample_computation.py", sys.exc_type, sys.exc_value
