#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()

try :
   eps = 0.4
   #Instance creation
   myFunc = NumericalMathFunction("TestResponseSurface")
   center = NumericalPoint(myFunc.getInputNumericalPointDimension())
   for i in range(center.getDimension()) :
      center[i] = 1.0+i
   myTaylor = QuadraticTaylor(center, myFunc)
   myTaylor.run()
   responseSurface = NumericalMathFunction(myTaylor.getResponseSurface())
   print "myTaylor=", myTaylor 
   print "responseSurface=", responseSurface 
   print "myFunc(", center, ")=", myFunc(center)
   print "responseSurface(", center, ")=", responseSurface(center) 
   inPoint = NumericalPoint(center)
   inPoint[0] += eps
   inPoint[1] -= eps/2
   print "myFunc(", inPoint, ")=", myFunc(inPoint)
   print "responseSurface(", inPoint, ")=", responseSurface(inPoint)

except : 
    import sys
    print "t_QuadraticTaylor_std.py", sys.exc_type, sys.exc_value
