#! /usr/bin/env python

from openturns import *
from math import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try :

  #########################################################################################################
  # Physical model
  #########################################################################################################
  
  inputFunction = Description(26)
  inputFunction[0] = "R"
  inputFunction[1] = "S01"
  inputFunction[2] = "S02"
  inputFunction[3] = "S03"
  inputFunction[4] = "S04"
  inputFunction[5] = "S05"
  inputFunction[6] = "S06"
  inputFunction[7] = "S07"
  inputFunction[8] = "S08"
  inputFunction[9] = "S09"
  inputFunction[10] = "S10"
  inputFunction[11] = "S11"
  inputFunction[12] = "S12"
  inputFunction[13] = "S13"
  inputFunction[14] = "S14"
  inputFunction[15] = "S15"
  inputFunction[16] = "S16"
  inputFunction[17] = "S17"
  inputFunction[18] = "S18"
  inputFunction[19] = "S19"
  inputFunction[20] = "S20"
  inputFunction[21] = "S21"
  inputFunction[22] = "S22"
  inputFunction[23] = "S23"
  inputFunction[24] = "S24"
  inputFunction[25] = "S25"
  
  outputFunction = Description(1)
  outputFunction[0] = "G"
  
  formulas = Description(outputFunction.getSize())
  formulas[0] ="R-(S01^2.0)/1.0-(S02^2.0)/2.0-(S03^2.0)/3.0-(S04^2.0)/4.0-(S05^2.0)/5.0-(S06^2.0)/6.0-(S07^2.0)/7.0-(S08^2.0)/8.0-(S09^2.0)/9.0-(S10^2.0)/10.0-(S11^2.0)/11.0-(S12^2.0)/12.0-(S13^2.0)/13.0-(S14^2.0)/14.0-(S15^2.0)/15.0-(S16^2.0)/16.0-(S17^2.0)/17.0-(S18^2.0)/18.0-(S19^2.0)/19.0-(S20^2.0)/20.0-(S21^2.0)/21.0-(S22^2.0)/22.0-(S23^2.0)/23.0-(S24^2.0)/24.0-(S25^2.0)/25.0"
  
  EtatLimite = NumericalMathFunction(inputFunction, outputFunction, formulas)
  
  dim=EtatLimite.getInputNumericalPointDimension()
  print dim
  
  #########################################################################################################
  # Probabilistic model
  #########################################################################################################
  
  mean = NumericalPoint(dim, 0.0)
  mean[0] = 0.5
  mean[1] = 0.2
  mean[2] = 0.2
  mean[3] = 0.2
  mean[4] = 0.2
  mean[5] = 0.2
  mean[6] = 0.2
  mean[7] = 0.2
  mean[8] = 0.2
  mean[9] = 0.2
  mean[10] = 0.2
  mean[11] = 0.2
  mean[12] = 0.2
  mean[13] = 0.2
  mean[14] = 0.2
  mean[15] = 0.2
  mean[16] = 0.2
  mean[17] = 0.2
  mean[18] = 0.2
  mean[19] = 0.2
  mean[20] = 0.2
  mean[21] = 0.2
  mean[22] = 0.2
  mean[23] = 0.2
  mean[24] = 0.2
  mean[25] = 0.2
  
  sigma = NumericalPoint(dim, 0.0)
  sigma[0] = 0.1
  sigma[1] = 0.1
  sigma[2] = 0.1
  sigma[3] = 0.1
  sigma[4] = 0.1
  sigma[5] = 0.1
  sigma[6] = 0.1
  sigma[7] = 0.1
  sigma[8] = 0.1
  sigma[9] = 0.1
  sigma[10] = 0.1
  sigma[11] = 0.1
  sigma[12] = 0.1
  sigma[13] = 0.1
  sigma[14] = 0.1
  sigma[15] = 0.1
  sigma[16] = 0.1
  sigma[17] = 0.1
  sigma[18] = 0.1
  sigma[19] = 0.1
  sigma[20] = 0.1
  sigma[21] = 0.1
  sigma[22] = 0.1
  sigma[23] = 0.1
  sigma[24] = 0.1
  sigma[25] = 0.1
  
  CORR = CorrelationMatrix(dim)
  myDistribution = Normal(mean, sigma, CORR)
  
  start=myDistribution.getMean()
  Covariance= myDistribution.getCovariance()
  
  #########################################################################################################
  # Limit state
  #########################################################################################################
  
  vect = RandomVector(myDistribution)
  
  output = RandomVector(EtatLimite, vect)
  
  myEvent = Event(output, ComparisonOperator(Less()), 0.0)
  
  #########################################################################################################
  # Calculs
  #########################################################################################################
  
  #########################################################################################################
  # FORM/SORM Cobyla
  myCobyla = Cobyla()
  myCobyla.setSpecificParameters(CobylaSpecificParameters())
  myCobyla.setMaximumIterationsNumber(100)
  myCobyla.setMaximumAbsoluteError(1.0e-10)
  myCobyla.setMaximumRelativeError(1.0e-10)
  myCobyla.setMaximumResidualError(1.0e-10)
  myCobyla.setMaximumConstraintError(1.0e-10)
  
  myAlgoC = FORM(NearestPointAlgorithm(myCobyla), myEvent, start)
  myAlgoC2 = SORM(NearestPointAlgorithm(myCobyla), myEvent, start)
  
  myAlgoC.run()
  myAlgoC2.run()
  
  resultC = FORMResult(myAlgoC.getResult())
  resultC2 = SORMResult(myAlgoC2.getResult())
  
  #########################################################################################################
  # FORM/SORM Abdo Rackwitz
  myAbdoRackwitz = AbdoRackwitz()
  myAbdoRackwitz.setSpecificParameters(AbdoRackwitzSpecificParameters())
  myAbdoRackwitz.setMaximumIterationsNumber(100)
  myAbdoRackwitz.setMaximumAbsoluteError(1.0e-10)
  myAbdoRackwitz.setMaximumRelativeError(1.0e-10)
  myAbdoRackwitz.setMaximumResidualError(1.0e-10)
  myAbdoRackwitz.setMaximumConstraintError(1.0e-10)
  
  myAlgoAR = FORM(NearestPointAlgorithm(myAbdoRackwitz), myEvent, start)
  myAlgoAR2 = SORM(NearestPointAlgorithm(myAbdoRackwitz), myEvent, start)
  
  myAlgoAR.run()
  myAlgoAR2.run()
  
  resultAR = FORMResult(myAlgoAR.getResult())
  resultAR2 = SORMResult(myAlgoAR2.getResult())
  
  #########################################################################################################
  # Monte Carlo
  CoV_MC=0.5
  myMC = MonteCarlo(myEvent)
  myMC.setMaximumOuterSampling(8000)
  myMC.setBlockSize(1)
  myMC.setMaximumCoefficientOfVariation(CoV_MC)
  myMC.run()
  
  #########################################################################################################
  # LHS
  CoV_LHS=0.1
  myLHS = LHS(myEvent)
  myLHS.setMaximumOuterSampling(8000)
  myLHS.setBlockSize(1)
  myLHS.setMaximumCoefficientOfVariation(CoV_LHS)
  myLHS.run()
  

  #########################################################################################################
  
  #########################################################################################################
  # Results
  #########################################################################################################
  
  #########################################################################################################
  # FORM/SORM Cobyla
  PfC = resultC.getEventProbability()
  Beta_generalizedC = resultC.getGeneralisedReliabilityIndex()
  u_starC = resultC.getStandardSpaceDesignPoint()
  x_starC = resultC.getPhysicalSpaceDesignPoint()
  PtC = resultC.getIsStandardPointOriginInFailureSpace() and "true" or "false"
  gammaC = resultC.getImportanceFactors()
  beta_hasoferC = resultC.getHasoferReliabilityIndex()
  SensitivityC = resultC.getEventProbabilitySensitivity()
  
  PFBreitC2 = resultC2.getEventProbabilityBreitung()
  BetaBreitC2 = resultC2.getGeneralisedReliabilityIndexBreitung()
  PFHBC2=resultC2.getEventProbabilityHohenBichler()
  BetaHBC2=resultC2.getGeneralisedReliabilityIndexHohenBichler()
  PFTvedtC2 = resultC2.getEventProbabilityTvedt()
  BetaTvedtC2 = resultC2.getGeneralisedReliabilityIndexTvedt()
  CurvC2 = resultC2.getSortedCurvatures()
  u_starC2 = resultC2.getStandardSpaceDesignPoint()
  x_starC2 = resultC2.getPhysicalSpaceDesignPoint()
  PtC2 = resultC2.getIsStandardPointOriginInFailureSpace() and "true" or "false"
  gammaC2 = resultC2.getImportanceFactors()
  beta_hasoferC2 = resultC2.getHasoferReliabilityIndex()
  
  #########################################################################################################
  # FORM/SORM Abdo Rackwitz
  PfAR = resultAR.getEventProbability()
  Beta_generalizedAR = resultAR.getGeneralisedReliabilityIndex()
  u_starAR = resultAR.getStandardSpaceDesignPoint()
  x_starAR = resultAR.getPhysicalSpaceDesignPoint()
  PtAR = resultAR.getIsStandardPointOriginInFailureSpace() and "true" or "false"
  gammaAR = resultAR.getImportanceFactors()
  beta_hasoferAR = resultAR.getHasoferReliabilityIndex()
  SensitivityAR = resultAR.getEventProbabilitySensitivity()
  
  PFBreitAR2 = resultAR2.getEventProbabilityBreitung()
  BetaBreitAR2 = resultAR2.getGeneralisedReliabilityIndexBreitung()
  PFHBAR2=resultAR2.getEventProbabilityHohenBichler()
  BetaHBAR2=resultAR2.getGeneralisedReliabilityIndexHohenBichler()
  PFTvedtAR2 = resultAR2.getEventProbabilityTvedt()
  BetaTvedtAR2 = resultAR2.getGeneralisedReliabilityIndexTvedt()
  CurvAR2 = resultAR2.getSortedCurvatures()
  u_starAR2 = resultAR2.getStandardSpaceDesignPoint()
  x_starAR2 = resultAR2.getPhysicalSpaceDesignPoint()
  PtAR2 = resultAR2.getIsStandardPointOriginInFailureSpace() and "true" or "false"
  gammaAR2 = resultAR2.getImportanceFactors()
  beta_hasoferAR2 = resultAR2.getHasoferReliabilityIndex()
  
  #########################################################################################################
  # Monte Carlo
  ResultMC = myMC.getResult()
  PFMC = ResultMC.getProbabilityEstimate()
  CVMC = ResultMC.getCoefficientOfVariation()
  Variance_PF_MC = ResultMC.getVarianceEstimate()
  length90MC = ResultMC.getConfidenceLength(0.90)
  
  #########################################################################################################
  # LHS
  ResultLHS = myLHS.getResult()
  PFLHS = ResultLHS.getProbabilityEstimate()
  CVLHS = ResultLHS.getCoefficientOfVariation()
  Variance_PF_LHS = ResultLHS.getVarianceEstimate()
  length90LHS = ResultLHS.getConfidenceLength(0.90)
  

  #########################################################################################################
  # Printting
  #########################################################################################################
  print  ""
  print  ""
  print  "************************************************************************************************"
  print  "***************************************** FORM  COBYLA *****************************************"
  print  "************************************************************************************************"
  print  "event probability =", PfC
  print  "generalized reliability index =" , Beta_generalizedC
  print  "************************************************************************************************"
  for i in range(u_starC.getDimension()) :
    print "standard space design point =" , u_starC[i]
  print  "************************************************************************************************"
  for i in range(x_starC.getDimension()) :
    print "physical space design point =" , x_starC[i]
  print  "************************************************************************************************"
  print "is standard point origin in failure space? " , PtC
  print  "************************************************************************************************"
  for i in range(gammaC.getDimension()) :
    print "importance factors =" , gammaC[i]
  print  "************************************************************************************************"
  print  "Hasofer reliability index =" , beta_hasoferC
  print  "************************************************************************************************"
  for i in range(SensitivityC.getSize()) :
    for j in range(SensitivityC[i].getDimension()) :
      print  "Pf sensitivity =",i,j, SensitivityC[i][j]
  print  "************************************************************************************************"
  print  ""
  print  "************************************************************************************************"
  print  "************************************** FORM ABDO RACKWITZ **************************************"
  print  "************************************************************************************************"
  print  "event probability =", PfAR
  print  "generalized reliability index =" , Beta_generalizedAR
  print  "************************************************************************************************"
  for i in range(u_starAR.getDimension()) :
    print "standard space design point =" , u_starAR[i]
  print  "************************************************************************************************"
  for i in range(x_starAR.getDimension()) :
    print "physical space design point =" , x_starAR[i]
  print  "************************************************************************************************"
  print "is standard point origin in failure space? " , PtAR
  print  "************************************************************************************************"
  for i in range(gammaAR.getDimension()) :
    print "importance factors =" , gammaAR[i]
  print  "************************************************************************************************"
  print  "Hasofer reliability index =" , beta_hasoferAR
  print  "************************************************************************************************"
  for i in range(SensitivityAR.getSize()) :
    for j in range(SensitivityAR[i].getDimension()) :
      print  "Pf sensitivity =",i,j, SensitivityAR[i][j]
  print  "************************************************************************************************"
  print  ""
  print  "************************************************************************************************"
  print  "***************************************** SORM  COBYLA *****************************************"
  print  "************************************************************************************************"
  print  "Breitung event probability =", PFBreitC2
  print  "Breitung generalized reliability index =", BetaBreitC2
  print  "HohenBichler event probability =", PFHBC2
  print  "HohenBichler generalized reliability index =", BetaHBC2
  print  "Tvedt event probability =", PFTvedtC2
  print  "Tvedt generalized reliability index =", BetaTvedtC2
  print  "************************************************************************************************"
  for i in range(CurvC2.getDimension()) :
    print "sorted curvatures =" , CurvC2[i]
  print  "************************************************************************************************"
  for i in range(u_starC2.getDimension()) :
    print "standard space design point =" , u_starC2[i]
  print  "************************************************************************************************"
  for i in range(x_starC2.getDimension()) :
    print "physical space design point =" , x_starC2[i]
  print  "************************************************************************************************"
  print  "************************************************************************************************"
  print "is standard point origin in failure space? " , PtC2
  print  "************************************************************************************************"
  for i in range(gammaC2.getDimension()) :
    print "importance factors =" , gammaC2[i]
  print  "************************************************************************************************"
  print  "Hasofer reliability index =" , beta_hasoferC2
  print  "************************************************************************************************"
  print  ""
  print  "************************************************************************************************"
  print  "************************************** SORM ABDO RACKWITZ **************************************"
  print  "************************************************************************************************"
  print  "Breitung event probability =", PFBreitAR2
  print  "Breitung generalized reliability index =", BetaBreitAR2
  print  "HohenBichler event probability =", PFHBAR2
  print  "HohenBichler generalized reliability index =", BetaHBAR2
  print  "Tvedt event probability =", PFTvedtAR2
  print  "Tvedt generalized reliability index =", BetaTvedtAR2
  print  "************************************************************************************************"
  for i in range(CurvAR2.getDimension()) :
    print "sorted curvatures =" , CurvAR2[i]
  print  "************************************************************************************************"
  for i in range(u_starAR2.getDimension()) :
    print "standard space design point =" , u_starAR2[i]
  print  "************************************************************************************************"
  for i in range(x_starAR2.getDimension()) :
    print "physical space design point =" , x_starAR2[i]
  print  "************************************************************************************************"
  print  "************************************************************************************************"
  print "is standard point origin in failure space? " , PtAR2
  print  "************************************************************************************************"
  for i in range(gammaAR2.getDimension()) :
    print "importance factors =" , gammaAR2[i]
  print  "************************************************************************************************"
  print  "Hasofer reliability index =" , beta_hasoferAR2
  print  "************************************************************************************************"
  print  ""
  print  "************************************************************************************************"
  print  "**************************************** MONTE CARLO *******************************************"
  print  "************************************************************************************************"
  print  "Pf estimation =", PFMC
  print  "Pf Variance estimation =", Variance_PF_MC
  print  "CoV =", CVMC
  print  "90% Confidence Interval =" , length90MC
  print  "CI at 90% =[" , PFMC-0.5*length90MC , ";" , PFMC+0.5*length90MC , "]"
  print  "************************************************************************************************"
  print  ""
  print  "************************************************************************************************"
  print  "******************************************* L H S **********************************************"
  print  "************************************************************************************************"
  print  "Pf estimation =", PFLHS
  print  "Pf Variance estimation =", Variance_PF_LHS
  print  "CoV =", CVLHS
  print  "90% Confidence Interval =" , length90LHS
  print  "CI at 90% =[" , PFLHS-0.5*length90LHS , ";" , PFLHS+0.5*length90LHS , "]"
  print  "************************************************************************************************"

except : 
  import sys
  print "t_Waarts_25_quadratic_terms.py", sys.exc_type, sys.exc_value
  