//                                               -*- C++ -*-
/**
 *  @file  IdFactory.cxx
 *  @brief The class IdFactory builds unique Ids for all Objects
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: IdFactory.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include <cstdlib>
#include "IdFactory.hxx"
#include "OSS.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /* The unique instance of the Singleton model */
      IdFactory * IdFactory::p_instance_ = 0;

      /* Default constructor */
      IdFactory::IdFactory() : nextId_(0)
      {
        // Nothing to do
      }

      /* Destructor */
      IdFactory::~IdFactory()
      {
        // Nothing to do
      }

      /* String converter */
      String IdFactory::__repr__() const
      {
	return OSS() << "class=IdFactory"
		     << " nextId_=" << nextId_;
      }


      /* The accessor to the Singleton element */
      IdFactory & IdFactory::getInstance()
      {
	if (!p_instance_) {
	  // this is the first call, we have to create the instance
	  p_instance_ = new IdFactory;

	  // Registration of destructor at exit
	  std::atexit(IdFactory::Release);
	}
	return *p_instance_;
      }


      /* Id accessor */
      Id IdFactory::buildId()
      {
	return nextId_++;
      }
	
      void IdFactory::Release()
      {
	delete p_instance_;
	p_instance_ = 0;
      }

      /*
       * @fn std::ostream & operator <<(std::ostream & os, const IdFactory & obj)
       * @brief Output stream converter
       * @param os A STL output stream object
       * @param obj The object read by \em os
       * @return A reference to \em os
       */
      std::ostream & operator <<(std::ostream & os, const IdFactory & obj)
      {
        return os << obj.__repr__();
      }

      OStream & operator <<(OStream & OS, const IdFactory & obj)
      {
        return OS << obj.__repr__();
      }



    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
