//                                               -*- C++ -*-
/**
 *  @file  Object.hxx
 *  @brief The class Object is the top-most class of Open TURNS
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: Object.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_OBJECT_HXX
#define OPENTURNS_OBJECT_HXX

#include <iostream>              // for std::ostream
#include <sstream>               // for std::ostringstream
#include "OTprivate.hxx"



/** Declare GetClassName() and getClassName() for Object-like classes */

#define CLASSNAME						\
  public:							\
  /**								\
   * Class name accessor					\
   * This method returns a string which is exactly the name	\
   * of the class (case-sensitive).				\
   */								\
  static  const OT::String & GetClassName();			\
  virtual const OT::String & getClassName() const;		\
  private:							\
  /** The name of the class */					\
  static const OT::String ClassName_;



/** Define GetClassName() and getClassName() for Object-like classes */

#define CLASSNAMEINIT(T)						\
  const OT::String   T::ClassName_(#T);					\
  const OT::String & T::GetClassName()       { return T::ClassName_; }	\
  const OT::String & T::getClassName() const { return T::ClassName_; }


#define TEMPLATE_CLASSNAMEINIT(T)						\
  template<> const OT::String   T::ClassName_(#T);			\
  template<> const OT::String & T::GetClassName()       { return T::ClassName_; } \
  template<> const OT::String & T::getClassName() const { return T::ClassName_; }



namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /**
       * @class Object
       *
       * Object defines common methods needed by all classes.
       * These are default constructor, copy constructor, virtual
       * destructor, affectation operator, comparison operator.
       * These methods must be overloaded by every derived class
       */

      class Object
      {
	CLASSNAME;
      public:

	/** Destructor */
	virtual ~Object() = 0;

	/**
	 * String converter
	 * This method shows human readable information on the
	 * internal state of an object. It is used when streaming
	 * the object or for user information.
	 */
	virtual String __repr__() const;


	/**
	 * Pretty string converter
	 * This method shows human readable information on the
	 * internal state of an object. It is used printing the object
	 * and should only show relevant information.
	 */
	virtual String __str__() const;


      protected:

      private:

      } ; /* class Object */

#ifndef SWIG
      /**
       * @fn std::ostream & operator <<(std::ostream & os, const Object & obj)
       * @brief Output stream converter
       * @param os A STL output stream object
       * @param obj The object read by \em os
       * @return A reference to \em os
       *
       * This method allows any Object-derived class to be streamed whitout
       * redefining this method. Each derived-class should have a public
       * method str() that returns a String.
       *
       * @sa String __repr__() const
       */
      std::ostream & operator <<(std::ostream & os, const Object & obj);

#endif

    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_OBJECT_HXX */
