//                                               -*- C++ -*-
/**
 *  @file  ThreadStatus.hxx
 *  @brief The class ThreadStatus owns Thread object internal information
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: ThreadStatus.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_THREADSTATUS_HXX
#define OPENTURNS_THREADSTATUS_HXX

#include <iostream>              // for std::ostream
#include "OTprivate.hxx"
#include "Object.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /**
       * @class ThreadStatus
       *
       * ThreadStatus objects own Thread object internal information like
       * thread identifier, internal state, related Threadable object, etc.
       * Those information are accessible readonly by the user.
       */

      class ThreadStatus
	: public Object
      {
	CLASSNAME;
      public:

	/** 
	 * Default constructor
	 * The default constructor allows the object to be
	 * stored in STL containers like vector or map.
	 */
	explicit ThreadStatus();

	/**
	 * String converter
	 * This method shows human readable information on the
	 * internal state of an object. It is used when streaming
	 * the object or for user information.
	 */
	virtual String __repr__() const;

      }; /* class Threadstatus */


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_THREADSTATUS_HXX */
