//                                               -*- C++ -*-
/**
 *  @file  Cloud.cxx
 *  @brief Cloud class for cloud plots
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: Cloud.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "Cloud.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Graph {

      CLASSNAMEINIT(Cloud);

      static Common::Factory<Cloud> RegisteredFactory("Cloud");

      /* Default constructor */
      Cloud::Cloud(const NumericalSample & data,
		   const String & legend)
	throw(InvalidArgumentException):
	DrawableImplementation(data, legend)
      {
	// Check data validity
	setData(data);
      }

      /* Constructor with parameters */
      Cloud::Cloud(const NumericalSample & data,
		   const String & color,
		   const String & pointStyle,
		   const String & legend)
	throw(InvalidArgumentException):
	DrawableImplementation(data, legend)
      {
	// Check data validity
	setData(data);
	setColor(color);
	setPointStyle(pointStyle);
      }

      /* String converter */
      String Cloud::__repr__() const
      {
	OSS oss;
	oss << "class=" << Cloud::GetClassName()
	    << " name=" << getName()
	    << " derived from " << DrawableImplementation::__repr__();
	return oss;
      }
   
      /* Draw method */
      String Cloud::draw() const
      {
	OSS oss;
	// Stores the data in a temporary file
	oss << DrawableImplementation::draw() << "\n";
	// The specific R command for drawing
	oss << "points(data[,1], data[,2]"
	    << ",pch=" << getPointCode(pointStyle_)
	    << ",col=\"" << color_
	    << "\")";
	
	return oss;
      }

      /* Clone method */
      Cloud * Cloud::clone() const
      {
	return new Cloud(*this);
      }

      /* Check validity of data */
      Bool Cloud::isValidData(const NumericalSample & data) const
      {
	return (data.getDimension() == 2);
      }

      /* Method save() stores the object through the StorageManager */
      void Cloud::save(const StorageManager::Advocate & adv) const
      {
      	DrawableImplementation::save(adv);
      }

      /* Method load() reloads the object from the StorageManager */
      void Cloud::load(const StorageManager::Advocate & adv)
      {
      	DrawableImplementation::load(adv);
      }

    }/* namespace Graph */

  }/* namespace Base */

}/* namespace OpenTURNS */
