//                                               -*- C++ -*-
/**
 *  @file  LeastSquaresAlgorithm.hxx
 *  @brief This Least Square Algorithm as a functor class
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_LEASTSQUARESALGORITHM_HXX
#define OPENTURNS_LEASTSQUARESALGORITHM_HXX

#include "OTprivate.hxx"
#include "PersistentObject.hxx"
#include "NumericalMathFunction.hxx"
#include "Collection.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      /**
       * @class LeastSquaresAlgorithm
       *
       * This Least Square Algorithm as a functor class
       */

      class LeastSquaresAlgorithm
	: public Base::Common::PersistentObject
      {
	CLASSNAME;
      public:

	typedef Common::StorageManager                  StorageManager;
	typedef Func::NumericalMathFunction             NumericalMathFunction;
	typedef Type::Collection<NumericalMathFunction> NumericalMathFunctionCollection;
	typedef Type::NumericalPoint                    NumericalPoint;
	typedef Stat::NumericalSample                   NumericalSample;

	// friend class Base::Common::Factory<LeastSquaresAlgorithm>;

	/** Default constructor */
	LeastSquaresAlgorithm();

	/** Parameters constructor */
	LeastSquaresAlgorithm(const NumericalSample & inputData,
			      const NumericalSample & outputData,
			      const NumericalPoint & weight,
			      const NumericalMathFunctionCollection & basis);

	/** Parameters constructor */
	LeastSquaresAlgorithm(const NumericalSample & inputData,
			      const NumericalSample & outputData,
			      const NumericalMathFunctionCollection & basis);

	/** Virtual constructor */
	virtual LeastSquaresAlgorithm * clone() const;

	/** Coefficients accessor */
	virtual NumericalPoint getCoefficients();

	/** Residual accessor */
	virtual NumericalScalar getResidual();

	/** String converter */
	virtual String __repr__() const;

	/** Method save() stores the object through the StorageManager */
	virtual void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	virtual void load(const StorageManager::Advocate & adv);

	/** Perform the optimization */
        void run();

      protected:

      private:

	NumericalSample inputSample_;
	NumericalSample outputSample_;
	NumericalPoint weight_;
	NumericalMathFunctionCollection basis_;
	NumericalPoint coefficients_;
	NumericalScalar residual_;
	mutable Bool isAlreadyComputedCoefficients_;

      } ; /* class LeastSquaresAlgorithm */


    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LEASTSQUARESALGORITHM_HXX */
