//                                               -*- C++ -*-
/**
 *  @file  NearestPointAlgorithm.cxx
 *  @brief NearestPointAlgorithm implements an algorithm for finding the 
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: NearestPointAlgorithm.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "NearestPointAlgorithm.hxx"
#include "Cobyla.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      CLASSNAMEINIT(NearestPointAlgorithm);

      /* Default constructor */
      NearestPointAlgorithm::NearestPointAlgorithm() :
	Common::TypedInterfaceObject<NearestPointAlgorithmImplementation>(new NearestPointAlgorithmImplementation()),
        Threadable()
      {
	// Nothing to do
      }

      /* Constructor from an implementation */
      NearestPointAlgorithm::NearestPointAlgorithm(const NearestPointAlgorithmImplementation & implementation) :
	Common::TypedInterfaceObject<NearestPointAlgorithmImplementation>(implementation.clone()),
        Threadable()
      {
	// Nothing to do
      }

      /* Constructor from a Pointer to an implementation */
      NearestPointAlgorithm::NearestPointAlgorithm(const Implementation & p_implementation) :
	Common::TypedInterfaceObject<NearestPointAlgorithmImplementation>(p_implementation),
        Threadable()
      {
	// Nothing to do
      }

      /*
       * @brief  Standard constructor: the problem is defined by a scalar valued function  (in fact, a 1-D vector valued function)
       *         and a level value
       */
      NearestPointAlgorithm::NearestPointAlgorithm(const NumericalMathFunction & levelFunction):
	Common::TypedInterfaceObject<NearestPointAlgorithmImplementation>(new Cobyla(levelFunction)),
        Threadable()
      {
	// Nothing to do
      }

      /* Starting point accessor */
      NearestPointAlgorithm::NumericalPoint NearestPointAlgorithm::getStartingPoint() const
      {
	return getImplementation()->getStartingPoint();
      }

      /* Starting point accessor */
      void NearestPointAlgorithm::setStartingPoint(const NumericalPoint & startingPoint)
      {
	getImplementation()->setStartingPoint(startingPoint);
      }

      /* Level value accessor */
      NumericalScalar NearestPointAlgorithm::getLevelValue() const
      {
	return getImplementation()->getLevelValue();
      }

      /* Level value accessor */
      void NearestPointAlgorithm::setLevelValue(const NumericalScalar levelValue)
      {
	getImplementation()->setLevelValue(levelValue);
      }

      /* Result accessor */
      NearestPointAlgorithm::Result NearestPointAlgorithm::getResult() const
      {
	return getImplementation()->getResult();
      }

      /* Result accessor */
      void NearestPointAlgorithm::setResult(const Result & result)
      {
	getImplementation()->setResult(result);
      }

      /* Maximum iterations number accessor */
      UnsignedLong NearestPointAlgorithm::getMaximumIterationsNumber() const
      {
	return getImplementation()->getMaximumIterationsNumber();
      }

      /* Maximum iterations number accessor */
      void NearestPointAlgorithm::setMaximumIterationsNumber(const UnsignedLong maximumIterationsNumber)
      {
	getImplementation()->setMaximumIterationsNumber(maximumIterationsNumber);
      }

      /* Maximum absolute error accessor */
      NumericalScalar NearestPointAlgorithm::getMaximumAbsoluteError() const
      {
	return getImplementation()->getMaximumAbsoluteError();
      }

      /* Maximum absolute error accessor */
      void NearestPointAlgorithm::setMaximumAbsoluteError(const NumericalScalar maximumAbsoluteError)
      {
	getImplementation()->setMaximumAbsoluteError(maximumAbsoluteError);
      }

      /* Maximum relative error accessor */
      NumericalScalar NearestPointAlgorithm::getMaximumRelativeError() const
      {
	return getImplementation()->getMaximumRelativeError();
      }

      /* Maximum relative error accessor */
      void NearestPointAlgorithm::setMaximumRelativeError(const NumericalScalar maximumRelativeError)
      {
	getImplementation()->setMaximumRelativeError(maximumRelativeError);
      }

      /* Maximum residual error accessor */
      NumericalScalar NearestPointAlgorithm::getMaximumResidualError() const
      {
	return getImplementation()->getMaximumResidualError();
      }

      /* Maximum residual error accessor */
      void NearestPointAlgorithm::setMaximumResidualError(const NumericalScalar maximumResidualError)
      {
	getImplementation()->setMaximumResidualError(maximumResidualError);
      }

      /* Maximum constraint error accessor */
      NumericalScalar NearestPointAlgorithm::getMaximumConstraintError() const
      {
	return getImplementation()->getMaximumConstraintError();
      }

      /* Maximum constraint error accessor */
      void NearestPointAlgorithm::setMaximumConstraintError(const NumericalScalar maximumConstraintError)
      {
	getImplementation()->setMaximumConstraintError(maximumConstraintError);
      }

      /* String converter */
      String NearestPointAlgorithm::__repr__() const
      {
	OSS oss;
	oss << "class=" << NearestPointAlgorithm::GetClassName()
            << " implementation=" << getImplementation()->__repr__();
	return oss;
      }

      /* Level function accessor */
      NearestPointAlgorithm::NumericalMathFunction NearestPointAlgorithm::getLevelFunction() const
      {
	return getImplementation()->getLevelFunction();
      }

      /* Level function accessor */
      void NearestPointAlgorithm::setLevelFunction(const NumericalMathFunction & levelFunction)
      {
	getImplementation()->setLevelFunction(levelFunction);
      }

      /* Performs the actual computation. Must be overloaded by the actual optimisation algorithm */
      void NearestPointAlgorithm::run()
	throw(InternalException)
      {
	getImplementation()->run();
      }

      /* Verbose accessor */
      Bool NearestPointAlgorithm::getVerbose() const
      {
	return getImplementation()->getVerbose();
      }

      /* Verbose accessor */
      void NearestPointAlgorithm::setVerbose(const Bool verbose)
      {
	getImplementation()->setVerbose(verbose);
      }

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */
