//                                               -*- C++ -*-
/**
 *  @file  SQP.hxx
 *  @brief SQP is an actual implementation for
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: SQP.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_SQP_HXX
#define OPENTURNS_SQP_HXX

#include "OTprivate.hxx"
#include "NearestPointAlgorithmImplementation.hxx"
#include "NumericalPoint.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      /**
       * @class SQP
       * SQP is an actual implementation for
       * NearestPointAlgorithm
       */

      class SQP :
            public NearestPointAlgorithmImplementation
      {
          CLASSNAME;

        public:

          typedef NearestPointAlgorithmImplementation::NumericalMathFunction NumericalMathFunction;
          typedef NearestPointAlgorithmImplementation::InternalException     InternalException;
          typedef Type::NumericalPoint                                       NumericalPoint;
          typedef Type::SymmetricMatrix                                      SymmetricMatrix;

#ifndef SWIG
          /**
           * @class SpecificParameters
           * Specific parameters of the cobyla library
           */

          class SpecificParameters
                : public Common::PersistentObject
          {
              /* Multiplicative decrease of linear step */
              static const NumericalScalar DefaultTau;
              /* Armijo factor */
              static const NumericalScalar DefaultOmega;
              /* Growing factor in penalization term */
              static const NumericalScalar DefaultSmooth;

              CLASSNAME;

            public:
              /** Default constructor */
              SpecificParameters();

              /** Parameters constructor */
              SpecificParameters(const NumericalScalar tau,
                                 const NumericalScalar omega,
                                 const NumericalScalar smooth);

              /** Virtual constructor */
              virtual SpecificParameters * clone() const;

              /** Tau accessor */
              NumericalScalar getTau() const;

              /** Tau accessor */
              void setTau(const NumericalScalar tau);

              /** Omega accessor */
              NumericalScalar getOmega() const;

              /** Omega accessor */
              void setOmega(const NumericalScalar tau);

              /** Smooth accessor */
              NumericalScalar getSmooth() const;

              /** Smooth accessor */
              void setSmooth(const NumericalScalar tau);

              /** String converter */
              String __repr__() const;

            private:

              /* Multiplicative decrease of linear step */
              NumericalScalar tau_;

              /* Armijo factor */
              NumericalScalar omega_;

              /* Growing factor in penalization term */
              NumericalScalar smooth_;

          }; /* class SpecificParameters */

#else
          typedef OT::Base::Optim::SQPSpecificParameters SpecificParameters;
#endif

          /** Default constructor */
          SQP();

          /** Constructor with parameters */
          SQP(const SpecificParameters & specificParameters,
              const NumericalMathFunction & levelFunction,
	      const Bool verbose = false);


          /** Virtual constructor */
          virtual SQP * clone() const;

          /** Performs the actual computation. Must be overloaded by the actual optimisation algorithm */
          void run()
          throw(InternalException);

          /** Specific parameters accessor */
          SpecificParameters getSpecificParameters() const;

          /** Specific parameters accessor */
          void setSpecificParameters(const SpecificParameters & specificParameters);
          /** String converter */
          String __repr__() const;

        private:

          /** Perform a line search in the given direction */
          NumericalScalar computeLineSearch();

          /** Abdo Rackwitz specific parameters */
          SpecificParameters specificParameters_;

          /** Abdo Rackwitz current penalization factor */
          NumericalScalar currentSigma_;

          /** Abdo Rackwitz current point */
          NumericalPoint currentPoint_;

          /** Abdo Rackwitz current direction */
          NumericalPoint currentDirection_;

          /** Abdo Rackwitz current level value */
          NumericalScalar currentLevelValue_;

          /** Abdo Rackwitz current gradient as a column vector */
          NumericalPoint currentGradient_;

          /** SQP current hessian as a symmetric tensor */
          SymmetricMatrix currentHessian_;

          /** SQP current system matrix as a symmetric matrix */
          SymmetricMatrix currentSystemMatrix_;

          /** SQP current system second member as a column vector */
          NumericalPoint currentSecondMember_;

          /** Abdo Rackwitz current Lagrange multiplier */
          NumericalScalar currentLambda_;

      }; /* class SQP */

      typedef OpenTURNS::Base::Optim::SQP::SpecificParameters  SQPSpecificParameters;

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_SQP_HXX */
