//                                               -*- C++ -*-
/**
 *  @file  CorrelationMatrix.hxx
 *  @brief The class CorrelationMatrix implements correlation matrices
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: CorrelationMatrix.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_CORRELATIONMATRIX_HXX
#define OPENTURNS_CORRELATIONMATRIX_HXX

#include "OTprivate.hxx"
#include "CovarianceMatrix.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Stat
    {

      /**
       * @class CorrelationMatrix
       */

      class CorrelationMatrix
	: public CovarianceMatrix
      {
	CLASSNAME;
	
      public:

	typedef Type::IdentityMatrix IdentityMatrix;

	/** Default constructor */
	CorrelationMatrix();
	 
	/** Constructor with size */ 
	CorrelationMatrix(UnsignedLong dim);

	/** Constructor from external collection */
	CorrelationMatrix(UnsignedLong dim,
			  const Type::Collection<NumericalScalar> & elementsValues);

	
	/** String converter */
	virtual String __repr__() const;

	/** CorrelationMatrix transpose */
	CorrelationMatrix transpose () const ;
	
	/** CorrelationMatrix multiplication (must have consistent dimensions) */
	CorrelationMatrix operator * (const IdentityMatrix & m) const throw(InvalidDimensionException);
	using CovarianceMatrix::operator *;
	
      protected:

            
        /** Constructor with implementation */
        CorrelationMatrix(const Implementation & i);
      
      private:
      }

      ; /* class CorrelationMatrix */



    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COVARIANCEMATRIX_HXX */
