//                                               -*- C++ -*-
/**
 *  @file  Null.cxx
 *  @brief 
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: Null.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "Null.hxx"

namespace OpenTURNS
{

  namespace Base 
  {

    namespace Stat
    {

      /**
       * @class Null
       */

      CLASSNAMEINIT(Null);

      /* Constructor with parameters */
      Null::Null()
	: HistoryStrategyImplementation()
      {
	// Nothing to do
      }

      /* Virtual constructor */
      Null * Null::clone() const
      {
	return new Null(*this);
      }

      /* Store the point according to the strategy */
      void Null::store(const NumericalPoint & point)
      {
	if (!isInitialized_)
	  {
	    sample_ = NumericalSample(0, point.getDimension());
	    isInitialized_ = true;
	  }
	return;
      }

      /* String converter */
      String Null::__repr__() const
      {
	OSS oss;
	oss << "class=" << Null::GetClassName();
	return oss;
      }

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */
