//                                               -*- C++ -*-
/**
 *  @file  SobolIndiceResult.cxx
 *  @brief SobolIndiceResult permits to choose which indices to compute
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2008-05-05 08:50:15 +0200 (lun, 05 mai 2008) $
 *  Id:      $Id: SobolIndiceResult.cxx 805 2008-05-05 06:50:15Z schueller $
 */

#include "CorrelationAnalysis.hxx"

namespace OpenTURNS
{
  namespace Base
  {
    namespace Stat
    {

      typedef Base::Type::NumericalPoint										NumericalPoint;
      typedef Base::Type::SymmetricMatrix										SymmetricMatrix;
      typedef Base::Type::SymmetricTensor										SymmetricTensor;

      CLASSNAMEINIT(CorrelationAnalysis::SobolIndiceResult);


      /** constructor with parameters */
      CorrelationAnalysis::SobolIndiceResult::SobolIndiceResult() :
	PersistentObject()
      {
	// Nothing to do
      }


      /** Virtual constructor */
      CorrelationAnalysis::SobolIndiceResult * CorrelationAnalysis::SobolIndiceResult::clone() const
      {
	return new SobolIndiceResult(*this);
      }


      /** first order Sobol' indices accessor */
      NumericalPoint CorrelationAnalysis::SobolIndiceResult::getFirstOrderIndice() const
      {
	return firstOrderIndice_;
      }

      void CorrelationAnalysis::SobolIndiceResult::setFirstOrderIndice(NumericalPoint firstOrderIndice)
      {
	firstOrderIndice_ = firstOrderIndice;
      }


      /** second order Sobol' indices accessor */
      SymmetricMatrix CorrelationAnalysis::SobolIndiceResult::getSecondOrderIndice() const
      {
	return secondOrderIndice_;
      }

      void CorrelationAnalysis::SobolIndiceResult::setSecondOrderIndice(const SymmetricMatrix secondOrderIndice)
      {
	secondOrderIndice_ = secondOrderIndice;
      }


      /** third order Sobol' indices accessor */
      SymmetricTensor CorrelationAnalysis::SobolIndiceResult::getThirdOrderIndice() const
      {
	return thirdOrderIndice_;
      }

      void CorrelationAnalysis::SobolIndiceResult::setThirdOrderIndice(const SymmetricTensor thirdOrderIndice)
      {
	thirdOrderIndice_ = thirdOrderIndice;
      }


      /** total order (order = dimension - 1) Sobol' indices accessor */
      NumericalPoint CorrelationAnalysis::SobolIndiceResult::getTotalOrderIndice() const
      {
	return totalOrderIndice_;
      }

      void CorrelationAnalysis::SobolIndiceResult::setTotalOrderIndice(const NumericalPoint totalOrderIndice)
      {
	totalOrderIndice_ = totalOrderIndice;
      }


      /** String converter */
      String CorrelationAnalysis::SobolIndiceResult::__repr__() const
      {
	OSS oss;
	oss << "class=" << CorrelationAnalysis::SobolIndiceResult::GetClassName()
	    << " firstOrderIndice=" << firstOrderIndice_
	    << " secondOrderIndice=" << secondOrderIndice_
	    << " thirdOrderIndice=" << thirdOrderIndice_
	    << " totalOrderIndice=" << totalOrderIndice_;
	return oss;
      }

    } // namespace Stat
  } // namespace Base
} // namespace OpenTURNS
