//                                               -*- C++ -*-
/**
 *  @file  Box.hxx
 *  @brief Box experiment plane
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: Box.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_BOX_HXX
#define OPENTURNS_BOX_HXX

#include "StratifiedExperiment.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      /**
       * @class Box
       *
       * The class describes the probabilistic concept of box experiment plan
       */
      class Box
	: public StratifiedExperiment
      {
	CLASSNAME;
      public:

	typedef StratifiedExperiment::NumericalPoint  NumericalPoint;
	typedef StratifiedExperiment::NumericalSample NumericalSample;
	typedef Base::Common::InvalidArgumentException    InvalidArgumentException;

	/** Default constructor */
	explicit Box(const String & name = OT::DefaultName);

	/** Constructor with parameters */
	explicit Box(const NumericalPoint & levels,
		     const String & name = OT::DefaultName)
	  throw(InvalidArgumentException);

	/** Virtual constructor */
	virtual Box * clone() const;

	/** Experiment plane generation :
         *  The box [0, 1]^n is uniformly sampled in each dimension
         */
	virtual NumericalSample generate();

	/** String converter */
	virtual String __repr__() const;

	/** Specific levels accessor */
	void setLevels(const NumericalPoint & levels) throw(InvalidArgumentException);

      }; /* class Box */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_BOX_HXX */
