//                                               -*- C++ -*-
/**
 *  @file  LHSExperiment.hxx
 *  @brief Abstract top-level view of an LHSExperiment plane
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu, 26 jun 2008) $
 *  Id:      $Id: LHSExperiment.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_LHSEXPERIMENT_HXX
#define OPENTURNS_LHSEXPERIMENT_HXX

#include "WeightedExperiment.hxx"
#include "Matrix.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      /**
       * @class LHSExperiment
       *
       * The class describes the probabilistic concept of LHSExperiment plan
       */
      class LHSExperiment
	: public WeightedExperiment
      {
	CLASSNAME;
      public:

	typedef WeightedExperiment::Distribution Distribution;
	typedef Base::Type::Matrix               Matrix;

	/** Default constructor */
	explicit LHSExperiment(const String & name = OT::DefaultName);

	/** Parameters constructor */
	explicit LHSExperiment(const UnsignedLong size,
			       const String & name = OT::DefaultName);

	/** Parameters constructor */
	explicit LHSExperiment(const Distribution & distribution,
			       const UnsignedLong size,
			       const String & name = OT::DefaultName);

	/** Virtual constructor */
	virtual LHSExperiment * clone() const;

	/** String converter */
	virtual String __repr__() const;

	/* Here is the interface that all derived class must implement */

	/** Sample generation */
	virtual NumericalSample generate();

	/** Shuffle accessor */
	virtual Matrix getShuffle() const;

      protected:
	/** Shuffle the cells. */
	void computeShuffle() const;

      private:
	/** Cells shuffle */
	mutable Matrix shuffle_;

	/** Flag to avoid redundant computation of the shuffle */
	mutable Bool isAlreadyComputedShuffle_;

      }; /* class LHSExperiment */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LHSEXPERIMENT_HXX */
