//                                               -*- C++ -*-
/**
 *  @file  WeightedExperiment.hxx
 *  @brief Abstract top-level view of an weightedExperiment plane
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu, 26 jun 2008) $
 *  Id:      $Id: WeightedExperiment.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_WEIGHTEDEXPERIMENT_HXX
#define OPENTURNS_WEIGHTEDEXPERIMENT_HXX

#include "ExperimentImplementation.hxx"
#include "Distribution.hxx"
#include "NumericalPoint.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      /**
       * @class WeightedExperiment
       *
       * The class describes the probabilistic concept of weightedExperiment plan
       */
      class WeightedExperiment
	: public ExperimentImplementation
      {
	CLASSNAME;
      public:
	// Default sampling size for WeightedExperiment instances
	static const UnsignedLong DefaultSize;

	typedef Model::Distribution        Distribution;
	typedef Base::Type::NumericalPoint NumericalPoint;

	/** Default constructor */
	explicit WeightedExperiment(const String & name = OT::DefaultName);

	/** Parameters constructor */
	explicit WeightedExperiment(const Distribution & distribution,
				    const UnsignedLong size,
				    const String & name = OT::DefaultName);

	/** Parameters constructor */
	explicit WeightedExperiment(const UnsignedLong size,
				    const String & name = OT::DefaultName);

	/** Virtual constructor */
	virtual WeightedExperiment * clone() const;

	/** String converter */
	virtual String __repr__() const;

	/** Distribution accessor */
	virtual void setDistribution(const Distribution & distribution);
	virtual Distribution getDistribution() const;

	/** Size accessor */
	virtual void setSize(const UnsignedLong size);
	virtual UnsignedLong getSize() const;

	/* Here is the interface that all derived class must implement */

	/** Sample generation */
	virtual NumericalSample generate();

	/** Weight accessor */
	virtual NumericalPoint getWeight() const;

      protected:

	/** Distribution that defines the weight of the experiment */
	Distribution distribution_;
	/** The size of the sample to be generated */
	UnsignedLong size_;
	/** The weights associated with the sample for numerical integration */
	NumericalPoint weight_;

      }; /* class WeightedExperiment */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_WEIGHTEDEXPERIMENT_HXX */
