//                                               -*- C++ -*-
/**
 *  @file  MarginalTransformationHessian.cxx
 *  @brief Class for the Nataf transformationHessian evaluation for elliptical
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: MarginalTransformationHessian.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "MarginalTransformationHessian.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {



      CLASSNAMEINIT(MarginalTransformationHessian);

      /* Parameter constructor */
      MarginalTransformationHessian::MarginalTransformationHessian(const DistributionCollection & distributionCollection):
	NumericalMathHessianImplementation(),
	distributionCollection_(distributionCollection)
      {
	// Nothing to do
      }

      /* Virtual constructor */
      MarginalTransformationHessian * MarginalTransformationHessian::clone() const
      {
	return new MarginalTransformationHessian(*this);
      }

      /* Hessian */
      MarginalTransformationHessian::SymmetricTensor MarginalTransformationHessian::hessian(const NumericalPoint & in) const
	throw (InvalidArgumentException, InternalException)
      {
	UnsignedLong dimension(getOutputNumericalPointDimension());
	SymmetricTensor result(dimension, dimension);
	// Apply DDF over the components
	for (UnsignedLong i = 0; i < dimension; ++i)
	  {
	    result(i, i, i) = distributionCollection_[i].computeDDF(NumericalPoint(1, in[i]))[0];
	  }
	return result;
      }
	  
      /* Accessor for input point dimension */
      UnsignedLong MarginalTransformationHessian::getInputNumericalPointDimension() const
	throw(InternalException)
      {
	return distributionCollection_.getSize();
      }

      /* Accessor for output point dimension */
      UnsignedLong MarginalTransformationHessian::getOutputNumericalPointDimension() const
	throw(InternalException)
      {
	return distributionCollection_.getSize();
      }

      /* String converter */
      String MarginalTransformationHessian::__repr__() const
      {
	OSS oss;
	oss << "class=" << MarginalTransformationHessian::GetClassName();                   
	return oss;
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

