//                                               -*- C++ -*-
/**
 *  @file  LeastSquaresStrategy.hxx
 *  @brief An implementation of projection strategy as a leastSquares
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_LEASTSQUARESSTRATEGY_HXX
#define OPENTURNS_LEASTSQUARESSTRATEGY_HXX

#include "ProjectionStrategyImplementation.hxx"
#include "NumericalSample.hxx"
#include "WeightedExperiment.hxx"
#include "Pointer.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class LeastSquaresStrategy
       *
       * An implementation of projection strategy as a leastSquares
       */

      class LeastSquaresStrategy
	: public ProjectionStrategyImplementation
      {
	CLASSNAME;
      public:

	typedef Base::Common::StorageManager                   StorageManager;
	typedef Base::Stat::NumericalSample                    NumericalSample;
	typedef Base::Common::Pointer<WeightedExperiment>      WeightedExperimentImplementation;
	typedef ProjectionStrategyImplementation::Distribution Distribution;

	// friend class Base::Common::Factory<LeastSquaresStrategy>;

	/** Default constructor */
	LeastSquaresStrategy();

	/** Parameter constructor */
	LeastSquaresStrategy(const Distribution & measure);

	/** Parameter constructor */
	LeastSquaresStrategy(const WeightedExperiment & weightedExperiment);

	/** Parameter constructor */
	LeastSquaresStrategy(const Distribution & measure,
			   const WeightedExperiment & weightedExperiment);

	/** Virtual constructor */
	virtual LeastSquaresStrategy * clone() const;

	/** String converter */
	String __repr__() const;

	/** Measure accessor */
	void setMeasure(const Distribution & measure);

	/** Experiment accessors */
	virtual void setExperiment(const WeightedExperiment & weightedExperiment);
	virtual WeightedExperiment getExperiment() const;

	/** Compute the components alpha_k_p_ by projecting the model on the partial L2 basis */
	void computeCoefficients(const NumericalMathFunction & function,
				 const NumericalMathFunctionCollection & partialBasis,
				 const Indices & indices,
				 const Indices & addedIndices,
				 const Indices & removedIndices);

	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(const StorageManager::Advocate & adv);


      protected:

      private:

	// An  experiment that will be used to discretize the L2 integral
	WeightedExperimentImplementation p_weightedExperiment_;

	// The input sample upon which the leastSquares will be made
	NumericalSample inputSample_;

	// The sample value of the model
	NumericalSample outputSample_;

      } ; /* class LeastSquaresStrategy */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LEASTSQUARESSTRATEGY_HXX */
