//                                               -*- C++ -*-
/**
 *  @file  ProjectionStrategyImplementation.cxx
 *  @brief This is a abstract class for projection strategy implementations
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.cxx 815 2008-05-21 09:21:38Z dutka $
 */
#include "ProjectionStrategyImplementation.hxx"
#include "OSS.hxx"
#include "PersistentObjectFactory.hxx"
#include "Exception.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      CLASSNAMEINIT(ProjectionStrategyImplementation);

      static Base::Common::Factory<ProjectionStrategyImplementation> RegisteredFactory("ProjectionStrategyImplementation");

      typedef Base::Common::NotYetImplementedException NotYetImplementedException;

      /* Default constructor */
      ProjectionStrategyImplementation::ProjectionStrategyImplementation()
	: Base::Common::PersistentObject(),
	  measure_()
      {
	// Nothing to do
      }


      /* Parameter constructor */
      ProjectionStrategyImplementation::ProjectionStrategyImplementation(const Distribution & measure)
	: Base::Common::PersistentObject(),
	  measure_(measure)
      {
	// Nothing to do
      }

      
      /* Virtual constructor */
      ProjectionStrategyImplementation * ProjectionStrategyImplementation::clone() const
      {
	return new ProjectionStrategyImplementation(*this);
      }


      /* String converter */
      String ProjectionStrategyImplementation::__repr__() const
      {
	return OSS() << "class=" << getClassName()
		     << " measure=" << measure_;
      }


      /* Measure accessor */
      void ProjectionStrategyImplementation::setMeasure(const Distribution & measure)
      {
	measure_ = measure;
      }

      ProjectionStrategyImplementation::Distribution ProjectionStrategyImplementation::getMeasure() const
      {
	return measure_;
      }


      /* Compute the components alpha_k_p_ by projecting the model on the partial L2 basis */
      void ProjectionStrategyImplementation::computeCoefficients(const NumericalMathFunction & function,
								 const NumericalMathFunctionCollection & partialBasis,
								 const Indices & indices,
								 const Indices & addedIndices,
								 const Indices & removedIndices)
      {
	throw NotYetImplementedException(HERE);
      }


      /* Method save() stores the object through the StorageManager */
      void ProjectionStrategyImplementation::save(const StorageManager::Advocate & adv) const
      {
	PersistentObject::save(adv);
      }


      /* Method load() reloads the object from the StorageManager */
      void ProjectionStrategyImplementation::load(const StorageManager::Advocate & adv)
      {
	PersistentObject::load(adv);
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
