//                                               -*- C++ -*-
/**
 *  @file  JacobiFactory.hxx
 *  @brief Jacobi polynomial factory
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_JACOBIFACTORY_HXX
#define OPENTURNS_JACOBIFACTORY_HXX

#include "OrthogonalUniVariatePolynomialFactory.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class JacobiFactory
       *
       * Jacobi polynomial factory
       */

      class JacobiFactory
	: public OrthogonalUniVariatePolynomialFactory
      {
	CLASSNAME;
      public:

	/** Default constructor: (1, 1) order Jacobi polynomial associated with the default Beta() = Beta(2, 4, -1, 1) distribution which is equal to the Epanechnikov distribution */
	JacobiFactory();

	/** Parameter constructor: (alpha, beta) is the order of the Jacobi polynomial, associated with the Beta(beta + 1, alpha + beta + 2, -1, 1) distribution */
	JacobiFactory(const NumericalScalar alpha,
		      const NumericalScalar beta);

	/** Virtual constructor */
	JacobiFactory * clone() const;

	/** Determine the coefficients of the first orthogonal Jacobi Polynomial (degree = 0) of the family*/
	Coefficients getP0Coefficients() const ;	

	/** Determine the coefficients of the second orthogonal Jacobi Polynomial (degree = 1) of the family*/
	Coefficients getP1Coefficients() const ;

	/** Calculate the coefficients of recurrence a0, a1, a2, a3 such that
	    Pn(x) = (a0 * x + a1) * Pn-1(x) + a2 * Pn-2(x) */
	Coefficients getRecurrenceCoefficients(const UnsignedLong n) const;
      
	/** Alpha accessor */
	NumericalScalar getAlpha() const;

	/** Beta accessor */
	NumericalScalar getBeta() const;

	/** String converter */
	String __repr__() const;

      private:
	/* First parameter of the Jacobi polynomial */
	NumericalScalar alpha_; 
	/* Second parameter of the Jacobi polynomial */
	NumericalScalar beta_; 
     
      } ; /* class JacobiFactory */
      

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_JACOBIFACTORY_HXX */
