//                                               -*- C++ -*-
/**
 *  @file  PostAnalyticalControlledImportanceSampling.hxx
 *  @brief PostAnalyticalControlledImportanceSampling is an implementation of the importance sampling Montex Carlo simulation method
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: PostAnalyticalControlledImportanceSampling.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_POSTANALYTICALCONTROLLEDIMPORTANCESAMPLING_HXX
#define OPENTURNS_POSTANALYTICALCONTROLLEDIMPORTANCESAMPLING_HXX

#include "PostAnalyticalSimulation.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class PostAnalyticalControlledImportanceSampling
       */

      class PostAnalyticalControlledImportanceSampling :
	public PostAnalyticalSimulation
      {

	CLASSNAME;
      public:

	typedef PostAnalyticalSimulation::NumericalSample          NumericalSample;
	typedef PostAnalyticalSimulation::InvalidArgumentException InvalidArgumentException;
	typedef PostAnalyticalSimulation::StandardEvent            StandardEvent;
	typedef PostAnalyticalSimulation::Distribution             Distribution;

	/** Constructor with parameters */
	PostAnalyticalControlledImportanceSampling(const AnalyticalResult & AnalyticalResult) throw(InvalidArgumentException);

	/** Virtual constructor */
	virtual PostAnalyticalControlledImportanceSampling * clone() const;

	/** String converter */
	String __repr__() const;

      private:

	/** Compute the block sample */
	NumericalSample computeBlockSample();

      } ; /* class PostAnalyticalControlledImportanceSampling */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_POSTANALYTICALCONTROLLEDIMPORTANCESAMPLING_HXX */
