//                                               -*- C++ -*-
/**
 *  @file  GammaFactory.hxx
 *  @brief Factory for Gamma distribution
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 10:54:56 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: GammaFactory.hxx 1261 2009-05-28 08:54:56Z dutka $
 */
#ifndef OPENTURNS_GAMMAFACTORY_HXX
#define OPENTURNS_GAMMAFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      /**
       * @class GammaFactory
       */
      class GammaFactory
	: public Model::DistributionImplementationFactory
      {
      public:

	typedef Model::DistributionImplementationFactory                    DistributionImplementationFactory; // required by SWIG
	typedef DistributionImplementationFactory::NumericalSample          NumericalSample;
	typedef DistributionImplementationFactory::InternalException        InternalException;
	typedef DistributionImplementationFactory::InvalidArgumentException InvalidArgumentException;
	typedef Model::DistributionImplementation                           DistributionImplementation;

	/** Default constructor */
	GammaFactory();

	/** Virtual constructor */
	virtual GammaFactory * clone() const;

	/* Here is the interface that all derived class must implement */

	DistributionImplementation * buildImplementation(const NumericalSample & sample) const throw(InvalidArgumentException, InternalException);
	DistributionImplementation * buildImplementation(const NumericalPointCollection & parameters) const throw(InvalidArgumentException, InternalException);
	DistributionImplementation * buildImplementation() const throw(InvalidArgumentException, InternalException);

    
      }; /* class GammaFactory */


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_GAMMAFACTORY_HXX */
