//                                               -*- C++ -*-
/**
 *  @file  HistogramFactory.cxx
 *  @brief Factory for Histogram distribution
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 10:54:56 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: HistogramFactory.cxx 1261 2009-05-28 08:54:56Z dutka $
 */
#include "HistogramFactory.hxx"
#include "Histogram.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      typedef OT::Base::Common::NotYetImplementedException NotYetImplementedException;

      /* Default constructor */
      HistogramFactory::HistogramFactory()
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }

      /* Virtual constructor */
      HistogramFactory * HistogramFactory::clone() const
      {
	return new HistogramFactory(*this);
      }


      /* Here is the interface that all derived class must implement */

      HistogramFactory::DistributionImplementation * HistogramFactory::buildImplementation(const NumericalSample & sample) const throw(InvalidArgumentException, InternalException)
      {
	throw NotYetImplementedException(HERE);
      }

      HistogramFactory::DistributionImplementation * HistogramFactory::buildImplementation() const throw(InvalidArgumentException, InternalException)
      {
	return Histogram().clone();
      }


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
