//                                               -*- C++ -*-
/**
 *  @file  TestStrongMaximumTestDimension5.cxx
 *  @brief 
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-02-12 14:29:13 +0100 (jeu. 12 févr. 2009) $
 *  Id:      $Id: TestStrongMaximumTestDimension5.cxx 1132 2009-02-12 13:29:13Z dutka $
 */
#include <iostream>
#include <cstdlib>
#include "WrapperInterface.h"

namespace WrapperInternals {
  struct internalState {
    long numberOfCalls;
  };

  void internalStateInitialization(struct internalState * p_internalState)
  {
    if (p_internalState) p_internalState->numberOfCalls = 0;
  }

  void internalStateIncrement(struct internalState * p_internalState)
  {
    if (p_internalState) p_internalState->numberOfCalls++;
  }

  long internalStateGetNumberOfCalls(struct internalState * p_internalState)
  {
    return (p_internalState ? p_internalState->numberOfCalls : -1);
  }
} /* namespace WrapperInternals */

extern "C" {
  /* Function */
  enum WrapperErrorCode func_createState_TestDim5(void ** p_p_state, const struct WrapperExchangedData * p_exchangedData)
  {
    *p_p_state = malloc(sizeof(struct WrapperInternals::internalState));
    internalStateInitialization(static_cast<struct WrapperInternals::internalState *>(*p_p_state));
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_deleteState_TestDim5(void * p_state)
  {
    free(p_state);
    return WRAPPER_OK;
  }

  static struct WrapperInformation info_TestDim5 = {/* inSize_  = */ 5,
						    /* outSize_ = */ 1};

  enum WrapperErrorCode func_getInfo_TestDim5(void * p_state, struct WrapperInformation * p_info)
  {
    *p_info = info_TestDim5;
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_init_TestDim5(void * p_state)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_exec_TestDim5(void * p_state, const struct point * inPoint, struct point * outPoint)
  {
    internalStateIncrement(static_cast<struct WrapperInternals::internalState *>(p_state));
    //     double x1(inPoint->data_[0]);
    //     double x2(inPoint->data_[1]);
    //     double x3(inPoint->data_[2]);
    //     double x4(inPoint->data_[3]);
    //     double x5(inPoint->data_[4]);

    outPoint->data_[0] = 0;
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_exec_sample_TestDim5(void * p_state, const struct sample * inSample, struct sample * outSample)
  {
    unsigned long inDimension((inSample->data_[0]).size_);
    if (info_TestDim5.inSize_ != inDimension) return WRAPPER_WRONG_ARGUMENT;
    unsigned long outDimension((outSample->data_[0]).size_);
    if (info_TestDim5.outSize_ != outDimension) return WRAPPER_WRONG_ARGUMENT;
    unsigned long size(inSample->size_);
    for (unsigned long i = 0; i < size; i++)
      {
        if (func_exec_TestDim5(p_state, &(inSample->data_[i]),  &(outSample->data_[i])) != WRAPPER_OK) return WRAPPER_EXECUTION_ERROR;
      }
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_finalize_TestDim5(void * p_state)
  {
    return WRAPPER_OK;
  }
  /* Gradient, which is void at this time */
  enum WrapperErrorCode grad_createState_TestDim5(void ** p_p_state, const struct WrapperExchangedData * p_exchangedData)
  {
    *p_p_state = malloc(sizeof(struct WrapperInternals::internalState));
    internalStateInitialization(static_cast<struct WrapperInternals::internalState *>(*p_p_state));
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_deleteState_TestDim5(void * p_state)
  {
    free(p_state);
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_getInfo_TestDim5(void * p_state, struct WrapperInformation * p_info)
  {
    *p_info = info_TestDim5;
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_init_TestDim5(void * p_state)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_exec_TestDim5(void * p_state, const struct point * inPoint, struct matrix * outMatrix)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_finalize_TestDim5(void * p_state)
  {
    return WRAPPER_OK;
  }
  /* Hessian, which is void at this time */
  enum WrapperErrorCode hess_createState_TestDim5(void ** p_p_state, const struct WrapperExchangedData * p_exchangedData)
  {
    *p_p_state = malloc(sizeof(struct WrapperInternals::internalState));
    internalStateInitialization(static_cast<struct WrapperInternals::internalState *>(*p_p_state));
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_deleteState_TestDim5(void * p_state)
  {
    free(p_state);
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_getInfo_TestDim5(void * p_state, struct WrapperInformation * p_info)
  {
    *p_info = info_TestDim5;
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_init_TestDim5(void * p_state)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_exec_TestDim5(void * p_state, const struct point * inPoint, struct tensor * outTensor)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_finalize_TestDim5(void * p_state)
  {
    return WRAPPER_OK;
  }
} /* end extern "C" */
