//                                               -*- C++ -*-
/**
 *  @file  t_Curve_std.cxx
 *  @brief The test file of class Curve for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: t_Curve_std.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include <iostream>
#include <sstream>
#include <cstdlib>

#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "Graph.hxx"
#include "Curve.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Base::Graph;
using namespace std;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    // Generate the data for the curves to be drawn
    UnsignedLong size = 50;
    NumericalPoint cursor(2);

    NumericalSample data1(size, 2); //curve y = 2x for x in [-2;5]
    NumericalSample data2(size, 2); //curve y = x*x for x in [-1;1]

    NumericalScalar tmp;
    for(UnsignedLong i=0; i<size; i++)
      {
	tmp = 7.*i/size-2;
	cursor[0] = NumericalScalar(tmp);
	cursor[1] = NumericalScalar(2*tmp);
	data1[i] = cursor;

	tmp = 2.*i/size-1;
	cursor[0] = NumericalScalar(tmp);
	cursor[1] = NumericalScalar(tmp*tmp);
	data2[i] = cursor;
      }

    // Create an empty graph
    Graph myGraph("Some curves", "x1", "x2", true,"topright");

    // Create the first cloud
    Curve myCurve1(data1, "blue", "dashed", 2, "linear function");

    // Then, draw it
    myGraph.addDrawable(myCurve1);
    myGraph.draw("Graph_Curve_a_OT", 640, 480);

    // Check that the correct files have been generated by computing their checksum
    fullprint << "bitmap=" << myGraph.getBitmap() << std::endl;
    fullprint << "postscript=" << myGraph.getPostscript() << std::endl;

    // Create the second cloud
    Curve myCurve2(data2, "red", "solid", 2, "polynomial function");

    // Add it to the graph and draw everything
    myGraph.addDrawable(myCurve2);
    myGraph.draw("Graph_Curve_b_OT", 640, 480);
    fullprint << "bitmap=" << myGraph.getBitmap() << std::endl;
    fullprint << "postscript=" << myGraph.getPostscript() << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
