//                                               -*- C++ -*-
/**
 *  @file  t_LeastSquaresAlgorithm_std.cxx
 *  @brief The test file of class LeastSquaresAlgorithm for the standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-08-01 16:47:51 +0200 (mer, 01 aoû 2007) $
 *  Id:      $Id: t_LeastSquaresAlgorithm_std.cxx 488 2007-08-01 14:47:51Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalMathFunction.hxx"
#include "LeastSquaresAlgorithm.hxx"
#include "Description.hxx"
#include "NumericalSample.hxx"
#include "Exception.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Optim;
using namespace OT::Base::Stat;
using namespace OT::Base::Type;
using namespace OT::Base::Func;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    UnsignedLong dimension(2);
    // Reference function
    Description inVar(dimension);
    inVar[0] = "x1";
    inVar[1] = "x2";
    Description outVar(1);
    outVar[0] = "y";
    Description formula(1);
    formula[0] = "x1^3+1.5*x2^3-x1*x2";
    NumericalMathFunction model(inVar, outVar, formula);

    // Basis upon which we will project the model
    LeastSquaresAlgorithm::NumericalMathFunctionCollection basis(4);
    formula[0] = "x1";
    basis[0] = NumericalMathFunction(inVar, outVar, formula);
    formula[0] = "x2";
    basis[1] = NumericalMathFunction(inVar, outVar, formula);
    formula[0] = "x1^2";
    basis[2] = NumericalMathFunction(inVar, outVar, formula);
    formula[0] = "x2^2";
    basis[3] = NumericalMathFunction(inVar, outVar, formula);

    // Input sample
    UnsignedLong size(5);
    NumericalSample inputSample(size * size, dimension);
    NumericalPoint weight(inputSample.getSize());
    for (UnsignedLong i = 0; i < inputSample.getSize(); ++i)
      {
	inputSample[i][0] = NumericalScalar(i % size) / size;
	inputSample[i][1] = NumericalScalar (i / size) / size;
	weight[i] = (i % size + 1) * (i / size + 1);
      }
    // Variable weight
    {
      LeastSquaresAlgorithm algo(inputSample, model(inputSample), weight, basis);
      fullprint << "Algo=" << algo << std::endl;
      fullprint << "Coefficients=" << algo.getCoefficients() << std::endl;
      fullprint << "Residual=" << algo.getResidual() << std::endl;
    }
    // Uniform weight
    {
      LeastSquaresAlgorithm algo(inputSample, model(inputSample), NumericalPoint(inputSample.getSize(), 1.0), basis);
      fullprint << "Algo=" << algo << std::endl;
      fullprint << "Coefficients=" << algo.getCoefficients() << std::endl;
      fullprint << "Residual=" << algo.getResidual() << std::endl;
    }
  }

  catch (OT::Base::Common::NotSymmetricDefinitePositiveException & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }
  
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
