//                                               -*- C++ -*-
/**
 *  @file  t_Pie_std.cxx
 *  @brief The test file of class Pie for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: t_Pie_std.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include <iostream>
#include <sstream>
#include <cstdlib>

#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "Graph.hxx"
#include "Pie.hxx"
#include "Collection.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Base::Graph;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    NumericalSample data(0, 1);
    Description palette;
    Description labels;

    data.add(NumericalPoint(1,5665855));
    labels.add("chirac");
    palette.add("blue");

    data.add(NumericalPoint(1,4804713));
    labels.add("lepen");
    palette.add("white");

    data.add(NumericalPoint(1,4610113));
    labels.add("jospin");
    palette.add("pink");

    data.add(NumericalPoint(1,1949170));
    labels.add("bayrou");
    palette.add("yellow");

    data.add(NumericalPoint(1,1630045));
    labels.add("laguiller");
    palette.add("red");

    data.add(NumericalPoint(1,1518528));
    labels.add("chevenement");
    palette.add("ivory");

    data.add(NumericalPoint(1,1495724));
    labels.add("mamere");
    palette.add("green");

    data.add(NumericalPoint(1,1210562));
    labels.add("besancenot");
    palette.add("orange");

    data.add(NumericalPoint(1,1204689));
    labels.add("saint-josse");
    palette.add("maroon");

    data.add(NumericalPoint(1,1113484));
    labels.add("madelin");
    palette.add("violet");

    data.add(NumericalPoint(1,3295588));
    labels.add("cumul candidats < 3.5% ");
    palette.add("purple");
     

    // Create an empty graph
    Graph myGraph("Presidentielle 2002 - 1er tour", "", "", false,"");

    // Create the first cloud
    Pie myPie1(data, labels, NumericalPoint(2), 1, palette);

    // Then, draw it
    myGraph.addDrawable(myPie1);
    myGraph.draw("Graph_Pie_OT", 640, 480);

    // Check that the correct files have been generated by computing their checksum
    fullprint << "bitmap=" << myGraph.getBitmap() << std::endl;
    fullprint << "postscript=" << myGraph.getPostscript() << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
