//                                               -*- C++ -*-
/**
 *  @file  Brent.hxx
 *  @brief Implementation class of the scalar nonlinear solver based on
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: Brent.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_BRENT_HXX
#define OPENTURNS_BRENT_HXX

#include "OTprivate.hxx"
#include "SolverImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Solver {


      /*
       * @class Brent
       *
       * This class is an interface for the 1D nonlinear solverImplementations
       */
      class Brent : public SolverImplementation
      {
        CLASSNAME;
      public:

        typedef SolverImplementation::NumericalMathFunction NumericalMathFunction;
        typedef SolverImplementation::InvalidDimensionException InvalidDimensionException;
        typedef SolverImplementation::InternalException InternalException;

        /* Default constructor */
        explicit Brent();

        /* Parameter constructor */
        explicit Brent(const NumericalScalar absoluteError,
                       const NumericalScalar relativeError,
                       const UnsignedLong maximumFunctionEvaluation);


        /* Copy constructor */

        /* Virtual constructor */
        virtual Brent * clone() const;

        /* String converter */
        String __repr__() const;

        /* Solve attempt to find one root to the equation function(x) = value in [infPoint, supPoint] given function(infPoint) and function(supPoint) with the Brent method */
        using SolverImplementation::solve;
        NumericalScalar solve(const NumericalMathFunction & function,
                              const NumericalScalar value,
                              const NumericalScalar infPoint,
                              const NumericalScalar supPoint,
                              const NumericalScalar infValue,
                              const NumericalScalar supValue)
	  /* throw(InternalException, InvalidDimensionException) */;

      private:

      }; /* Class Brent */

    } /* namespace Solver */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_BRENT_HXX */
