//                                               -*- C++ -*-
/**
 *  @file  VisualTest.hxx
 *  @brief StatTest implements statistical tests
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: VisualTest.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_VISUALTEST_HXX
#define OPENTURNS_VISUALTEST_HXX

#include "OTprivate.hxx"
#include "Exception.hxx"
#include "NumericalSample.hxx"
#include "LinearModel.hxx"
#include "Distribution.hxx"
#include "DistributionImplementation.hxx"
#include "Normal.hxx"
#include "Graph.hxx"

namespace OpenTURNS
{
  namespace Uncertainty
  {
    namespace StatTest
    {

      /**
       * @class Test
       *
       */

      class VisualTest
      {
      public:

	typedef Base::Common::InvalidArgumentException  InvalidArgumentException;
	typedef Base::Common::InvalidDimensionException InvalidDimensionException;
	typedef Base::Graph::Graph                      Graph;
	typedef Base::Stat::NumericalSample             NumericalSample;
	typedef Base::Stat::LinearModel                 LinearModel; 
	typedef Distribution::Normal                    Normal;
	typedef Model::Distribution                     Distribution;
	typedef Model::DistributionImplementation       DistributionImplementation;

	/** Default constructor, needed by SWIG */
	VisualTest();

	/** Draw the empirical CDF of the Sample when its dimension is 1 */
	static Graph DrawEmpiricalCDF(const NumericalSample & sample,
				      const NumericalScalar xMin,
				      const NumericalScalar xMax)
	  /* throw(InvalidDimensionException, InvalidArgumentException) */;
	  
	  
	/** Draw the Histogram of the Sample when its dimension is 1 */
	static Graph DrawHistogram(const NumericalSample & sample, 
			           const UnsignedLong BarNumber) 
	  /* throw(InvalidDimensionException, InvalidArgumentException) */;
	
	/** Draw the Histogram of the Sample when its dimension is 1, using the Normal empirical rule */
	static Graph DrawHistogram(const NumericalSample & sample)
	  /* throw(InvalidDimensionException) */;
	
	/** Draw the QQplot of two Samples when its dimension is 1 */
	static Graph DrawQQplot(const NumericalSample & sample1, 
				const NumericalSample & sample2, 
				const UnsignedLong pointNumber = DistributionImplementation::DefaultPointNumber) 
	  /* throw(InvalidDimensionException, InvalidArgumentException) */;	
	
	
	/** Draw the QQplot of one Sample and one Distribution when its dimension is 1 */
	static Graph DrawQQplot(const NumericalSample & sample,
				const Distribution & dist,
				const UnsignedLong pointNumber = DistributionImplementation::DefaultPointNumber)
	  /* throw(InvalidDimensionException, InvalidArgumentException) */;

	/** Draw the Henry curve for one Sample when its dimension is 1 */
	static Graph DrawHenryLine(const NumericalSample & sample) 
	  /* throw(InvalidDimensionException, InvalidArgumentException) */;
	
	/** Draw the clouds of one Sample and one model when its dimension is 2 */	
	static Graph DrawClouds(const NumericalSample & sample1, 
				const Distribution & dist) 
	  /* throw(InvalidDimensionException, InvalidArgumentException) */;
	
	/** Draw the clouds of two Samples when its dimension is 2 */	
	static Graph DrawClouds(const NumericalSample & sample1, 
				const NumericalSample & sample2) 
	  /* throw(InvalidDimensionException, InvalidArgumentException) */;
	
	/** Draw the visual test for the LM when its dimension is 1 */
	static Graph DrawLMVisualTest(const NumericalSample & sample1, 
				      const NumericalSample & sample2, 
				      const LinearModel & lm) 
	  /* throw(InvalidDimensionException, InvalidArgumentException) */;	
	
	/** Draw the visual test for the LM when its dimension is 1 */
	static Graph DrawLMResidualTest(const NumericalSample & sample1, 
					const NumericalSample & sample2, 
					const LinearModel & lm)
	  /* throw(InvalidDimensionException, InvalidArgumentException) */;			    
	  
      }; /* class VisualTest */

    } /* namespace StatTest */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
#endif /* OPENTURNS_VISUALTEST_HXX */
