// SWIG file Histogram.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-11-09 17:38:15 +0100 (lun. 09 nov. 2009) $
// Id : $Id: Histogram.i 1403 2009-11-09 16:38:15Z dutka $

%{
#include "PythonWrappingFunctions.hxx"
#include "Histogram.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Uncertainty::Distribution::Histogram::Pair>
  {
    typedef _PyObject_ Type;
  };

  template <>
  inline
  OpenTURNS::Uncertainty::Distribution::Histogram::Pair *
  buildObjectFromPySequence<OpenTURNS::Uncertainty::Distribution::Histogram::Pair>(PyObject * pyObj)
  {
    check<_PySequence_>( pyObj );

    const UnsignedLong size = PySequence_Fast_GET_SIZE( pyObj );
    if (size != 2) {
      throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Sequence object has incorrect size " << size << ". Must be 2.";
    }
    PyObject * elt1 = PySequence_Fast_GET_ITEM( pyObj, 0 );
    check<_PyFloat_>( elt1 );
    PyObject * elt2 = PySequence_Fast_GET_ITEM( pyObj, 1 );
    check<_PyFloat_>( elt2 );
    return new OpenTURNS::Uncertainty::Distribution::Histogram::Pair( convert<_PyFloat_,OpenTURNS::NumericalScalar>( elt1 ),
								      convert<_PyFloat_,OpenTURNS::NumericalScalar>( elt2 ) );
  }

  template <>
  inline
  OpenTURNS::Uncertainty::Distribution::Histogram::Pair
  convert<_PySequence_,OpenTURNS::Uncertainty::Distribution::Histogram::Pair>(PyObject * pyObj)
  {
    OpenTURNS::Base::Common::Pointer<OpenTURNS::Uncertainty::Distribution::Histogram::Pair> ptr = buildObjectFromPySequence<OpenTURNS::Uncertainty::Distribution::Histogram::Pair>( pyObj );
    return *ptr;
  }

  template <>
  inline
  OpenTURNS::Uncertainty::Distribution::Histogram::Pair
  convert<_PyObject_,OpenTURNS::Uncertainty::Distribution::Histogram::Pair>(PyObject * pyObj)
  {
    void * ptr = 0;
    if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIG_TypeQuery("OpenTURNS::Uncertainty::Distribution::Histogram::Pair *"), 0 |  0 ))) {
      OpenTURNS::Uncertainty::Distribution::Histogram::Pair * p_hp = reinterpret_cast< OpenTURNS::Uncertainty::Distribution::Histogram::Pair * >( ptr );
      return *p_hp;

    } else if (isAPython<_PySequence_>( pyObj )) {
      return convert<_PySequence_,OpenTURNS::Uncertainty::Distribution::Histogram::Pair>( pyObj );

    } else {
      throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Object passed as argument is neither an HistogramPair nor an object convertible to an HistogramPair";
    }
    return OpenTURNS::Uncertainty::Distribution::Histogram::Pair();
  }


} /* namespace OpenTURNS */

%}

%include Histogram.hxx


namespace OpenTURNS { namespace Uncertainty { namespace Distribution {
struct HistogramPair {
  NumericalScalar h_;
  NumericalScalar l_;
  HistogramPair();
  HistogramPair(NumericalScalar h, NumericalScalar l);
  ~HistogramPair();
}; /* end struct Pair */

%extend HistogramPair {
  const String __str__() const
  {
    return OT::OSS() << "("
                     << self->h_ << ", "
                     << self->l_ << ")";
  }
  
  const String __repr__() const
  {
    return OT::OSS() << "HistogramPair(("
                     << self->h_ << ", "
                     << self->l_ << "))";
  }

  HistogramPair(PyObject * pyObj)
  {
    return OpenTURNS::buildObjectFromPySequence<OT::Uncertainty::Distribution::Histogram::Pair>( pyObj );
  }

}

}}}

%template(HistogramPairCollection) OpenTURNS::Base::Type::Collection<OpenTURNS::Uncertainty::Distribution::HistogramPair>;

%extend OpenTURNS::Base::Type::Collection<OpenTURNS::Uncertainty::Distribution::HistogramPair>
{

OpenTURNS::Base::Type::Collection<OpenTURNS::Uncertainty::Distribution::HistogramPair> (PyObject * pyObj)
{
  return OpenTURNS::buildCollectionFromPySequence<OT::Uncertainty::Distribution::Histogram::Pair>( pyObj );
}

}





namespace OpenTURNS { namespace Uncertainty { namespace Distribution {

%extend Histogram {
  Histogram(NumericalScalar first, const OpenTURNS::Base::Type::Collection<OpenTURNS::Uncertainty::Distribution::HistogramPair> & collection)
  {
    return new OpenTURNS::Uncertainty::Distribution::Histogram(first,collection);
  }
}

}}}
namespace OpenTURNS { namespace Uncertainty { namespace Distribution { %extend Histogram { Histogram(const Histogram & other) { return new OpenTURNS::Uncertainty::Distribution::Histogram(other); } } }}}
