#                                               -*- Autoconf -*-
#
#  ot_check_threads.m4
#
#  (C) Copyright 2005-2011 EDF-EADS-Phimeca
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  @author: $LastChangedBy: schueller $
#  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
#  Id:      $Id: ot_check_threads.m4 1866 2011-04-11 10:32:27Z schueller $
#
#
#  This file is intended to be include in the configure.in file
#  of Open TURNS project to check if thread support is available
#
# OT_CHECK_THREADS
# ----------------
#
AC_DEFUN([OT_CHECK_THREADS],
[
 AC_ARG_VAR([THREADFLAGS], [an optionnal flag to enable threading at compile time])

 WITH_THREADS=0

 AC_CHECK_HEADERS([pthread.h])

 # We check if some thread specific flags were set
 thread_flags=$THREADFLAGS
 if test "x$thread_flags" = "x"
 then
   case $host_os in
   linux* )
     thread_flags="-pthread"
     ;;

   solaris* )
     thread_flags="-pthreads"
     ;;

   mingw* )
     thread_flags="-mthreads"
     ;;

   esac
 fi

 # We try to compile and link some code to see if threading is running
 OT_CXXFLAGS="$OT_CXXFLAGS $thread_flags"
 saved_CXXFLAGS=$CXXFLAGS
 CXXFLAGS=$OT_CXXFLAGS
 AC_LINK_IFELSE(
	   [AC_LANG_PROGRAM([[
			      #include <pthread.h>

			      void * f(void * arg) {}
			    ]],
			    [[
				pthread_t id;
				pthread_attr_t attr;
				pthread_create(&id, &attr, f, NULL);
				return 0;
			    ]])
	   ],
	   [link_ok=yes],
	   [link_ok=no])

 AC_CACHE_CHECK([for thread specific flags],
                [ac_cv_check_thread_flags],
		[test $link_ok = yes && ac_cv_check_thread_flags=$thread_flags])

 test $link_ok = yes && WITH_THREADS=1
 CXXFLAGS=$saved_CXXFLAGS
 AC_SUBST(OT_CXXFLAGS)
])
