//                                             -*- C++ -*-
/**
 *  @file  FiniteDifferenceStepImplementation.cxx
 *  @brief Implementation of finite difference step
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: slama $
 *  @date:   $LastChangedDate: 2008-11-19 16:10:42 +0100 (mer, 19 nov 2008) $
 *  Id:      $Id: FiniteDifferenceStepImplementation.cxx 1023 2008-11-19 15:10:42Z slama $
 */

#include "FiniteDifferenceStepImplementation.hxx"
#include "PersistentObjectFactory.hxx"
#include "SpecFunc.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Diff {
      
      typedef Func::SpecFunc SpecFunc;
      typedef Common::InvalidArgumentException            InvalidArgumentException;

      CLASSNAMEINIT(FiniteDifferenceStepImplementation);

      //       static Common::Factory<FiniteDifferenceStepImplementation> RegisteredFactory("FiniteDifferenceStepImplementation");

      FiniteDifferenceStepImplementation::FiniteDifferenceStepImplementation()
        : Base::Common::PersistentObject()
      {
      }

      FiniteDifferenceStepImplementation::FiniteDifferenceStepImplementation(const NumericalPoint & epsilon)
        : Base::Common::PersistentObject(),
          epsilon_(epsilon)
      {
      }

      void FiniteDifferenceStepImplementation::setEpsilon(const NumericalPoint & epsilon)
      {
        const UnsignedLong dimension( epsilon.getDimension() );
        for (UnsignedLong i = 0; i < dimension; ++ i)
          {
            if (epsilon[i] < SpecFunc::MinNumericalScalar ) throw InvalidArgumentException(HERE) << "Nul epsilon for component "<< i;
          }
        epsilon_ = epsilon;
      }

      FiniteDifferenceStepImplementation::NumericalPoint FiniteDifferenceStepImplementation::getEpsilon() const
      {
        return epsilon_;
      }

      /* String converter */
      String FiniteDifferenceStepImplementation::__repr__() const
      {
        OSS oss;
        oss << "class=" << FiniteDifferenceStepImplementation::GetClassName()
            << " epsilon=" << epsilon_.__repr__();
        return oss;
      }

      /* Method save() stores the object through the StorageManager */
      void FiniteDifferenceStepImplementation::save(StorageManager::Advocate & adv) const
      {
        PersistentObject::save(adv);
        adv.saveAttribute("epsilon_", epsilon_);
      }

      /* Method load() reloads the object from the StorageManager */
      void FiniteDifferenceStepImplementation::load(StorageManager::Advocate & adv)
      {
        PersistentObject::load(adv);
        adv.loadAttribute("epsilon_", epsilon_);
      }


    }/* namespace Diff */
  }/* namespace Base */
}/* namespace OpenTURNS */

