//                                               -*- C++ -*-
/**
 *  @file  LAR.hxx
 *  @brief Least Angle Regression Algorithm
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2010-11-09 13:44:00 +0100 (Tue, 09 Nov 2010) $
 *  Id:      $Id: LAR.hxx 1649 2010-11-09 12:44:00Z dutka $
 */
#ifndef OPENTURNS_LAR_HXX
#define OPENTURNS_LAR_HXX

#include <limits>
#include "Matrix.hxx"
#include "BasisSequenceFactoryImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class LAR
       *
       * A sequence of numerical math function collection.
       */
      class LAR
        : public BasisSequenceFactoryImplementation
      {
      CLASSNAME;
      public:

        typedef Type::Matrix                                        Matrix;
        typedef Common::StorageManager                              StorageManager;
        typedef BasisSequenceFactoryImplementation::NumericalSample NumericalSample;

        /** Default constructor */
        LAR(const Bool verbose = false);

        /** Virtual constructor */
        virtual LAR * clone() const;

        /** Method to create new BasisSequence objects */
        virtual BasisSequence build(const NumericalSample & x,
				    const NumericalSample & y,
				    const Basis & psi) const;

        /** String converter */
        virtual String __repr__() const;
        virtual String __str__(const String & offset = "") const;

        /** Method save() stores the object through the StorageManager */
        virtual void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        virtual void load(StorageManager::Advocate & adv);

      private:

      }; /* class LAR */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LAR_HXX */
