//                                               -*- C++ -*-
/**
 *  @file  Airy.hxx
 *  @brief This file includes all of the airy functions used in the platform
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-16 17:32:18 +0100 (mar. 16 févr. 2010) $
 *  Id:      $Id: Airy.hxx 1485 2010-02-16 16:32:18Z dutka $
 */
#ifndef OPENTURNS_AIRY_HXX
#define OPENTURNS_AIRY_HXX

#include "OTconfig.hxx"
#include "OTprivate.hxx"
#ifdef HAVE_FORTRANCINTERFACE
#  include "FortranCInterface.h"
#endif /* HAVE_FORTRANCINTERFACE */

extern "C"
{
  /** Function that evaluates the complex Airy function Ai(z) or its derivative Ai'(z) */
#define AIZ_F77 F77_FUNC(aiz,AIZ)
  void AIZ_F77(int *ifun, int *ifac, double *x0, double *y0, double *gair, double *gaii, int *irro);
  /** Function that evaluates the complex Airy function Bi(z) or its derivative Bi'(z) */
#define BIZ_F77 F77_FUNC(biz,BIZ)
  void BIZ_F77(int *ifun, int *ifac, double *x0, double *y0, double *gbir, double *gbii, int *irro);
}

#endif /* OPENTURNS_AIRY_HXX */
