//                                               -*- C++ -*-
/**
 *  @file  ConfidenceInterval.cxx
 *  @brief ConfidenceInterval implements the confidence interval
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: ConfidenceInterval.cxx 1866 2011-04-11 10:32:27Z schueller $
 */
#include "ConfidenceInterval.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Stat
    {

      CLASSNAMEINIT(ConfidenceInterval);

      static Common::Factory<ConfidenceInterval> RegisteredFactory("ConfidenceInterval");

      typedef Type::Description                Description;
      typedef Common::InvalidArgumentException InvalidArgumentException;

      /* Default constructor */
      ConfidenceInterval::ConfidenceInterval(const NumericalScalar firstPt,
                                             const NumericalScalar lastPt)
        /* throw(InvalidArgumentException) */
        : PersistentObject(),
          first_(firstPt),
          last_(lastPt)
      {
        if (firstPt > lastPt) throw InvalidArgumentException(HERE);
      }

      /* Virtual constructor */
      ConfidenceInterval * ConfidenceInterval::clone() const
      {
        return new ConfidenceInterval(*this);
      }

      /* Description Accessor */
      void ConfidenceInterval::setDescription(const Description & description)
      {
        description_ = description;
      }

      Description ConfidenceInterval::getDescription() const
      {
        return description_;
      }

      /* String converter */
      String ConfidenceInterval::__repr__() const
      {
        return OSS() << " [" << first_ << "; "
                     << last_ << "]";
      }

      /* Elements accessors */
      void ConfidenceInterval::setValues(const NumericalScalar firstPt,
                                         const NumericalScalar lastPt)
      /* throw(InvalidArgumentException) */
      {
        if (firstPt > lastPt) throw InvalidArgumentException(HERE);
        first_ = firstPt;
        last_ = lastPt;
      }

      const NumericalScalar & ConfidenceInterval::getFirst() const
      {
        return first_;
      }

      const NumericalScalar & ConfidenceInterval::getLast() const
      {
        return last_;
      }

      /* Method save() stores the object through the StorageManager */
      void ConfidenceInterval::save(StorageManager::Advocate & adv) const
      {
        PersistentObject::save(adv);
        adv.saveAttribute( "first_", first_);
        adv.saveAttribute( "last_",  last_);
        adv.saveAttribute( "description_", description_ );
      }

      /* Method load() reloads the object from the StorageManager */
      void ConfidenceInterval::load(StorageManager::Advocate & adv)
      {
        PersistentObject::load(adv);
        adv.loadAttribute( "first_", first_);
        adv.loadAttribute( "last_",  last_);
        adv.loadAttribute( "description_", description_ );
      }



      /* Comparison operator */
      Bool ConfidenceInterval::operator ==(const ConfidenceInterval & rhs) const
      {
        return ((this->getFirst() == rhs.getFirst()) && (this->getLast() == rhs.getLast()));
      }

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */
