//                                               -*- C++ -*-
/**
 *  @file  FaureSequence.hxx
 *  @brief Implementation of the Faure sequence
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy$
 *  @date:   $LastChangedDate$
 *  Id:      $Id$
 */

#ifndef OPENTURNS_FAURESEQUENCE_HXX
#define OPENTURNS_FAURESEQUENCE_HXX

#include "LowDiscrepancySequenceImplementation.hxx"

namespace OpenTURNS
{
  namespace Base
  {
    namespace Stat
    {
      /**
       * @class FaureSequence
       */

      class FaureSequence :
        public LowDiscrepancySequenceImplementation
      {
        CLASSNAME;

      public:

        // the initial seed
        static const UnsignedLong InitialSeed;

        typedef LowDiscrepancySequenceImplementation::NumericalPoint NumericalPoint;

      public:

        /** Constructor with parameters */
        explicit FaureSequence(const UnsignedLong dimension = 1);

        /** Virtual constructor */
        virtual FaureSequence * clone() const;

        /** Initialize the sequence */
        void initialize(const UnsignedLong dimension);

        /** Generate a quasi-random vector of numbers uniformly distributed over [0, 1[ */
        using LowDiscrepancySequenceImplementation::generate;
        NumericalPoint generate();

        /** String converter */
        String __repr__() const;

      private:
        /** Compute the initial binomial coefficients table associated with the modulus */
        void computeInitialBinomialCoefficients();

        /** Update the binomial table by adding one column to the triangular array */
        void updateBinomialCoefficients();

        /** Binomial for the generation of the sequence */
        UInt64Collection coefficients_;

        /** Modulus of the sequence, i.e. least prime number greater or equal to the dimension */
        uint64_t modulus_;

        /** Inverse of the modulus */
        NumericalScalar modulusInverse_;

        /** Current seed into the sequence */
        uint64_t seed_;

        /** Next value of the seed that needs a coefficient update */
        uint64_t seedBound_;

        /** Number of digits of the seed in base the modulus */
        UnsignedLong logSeed_;

      }; /* class FaureSequence */

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_FAURESEQUENCE_HXX */
