//                                               -*- C++ -*-
/**
 *  @file  HistoryStrategy.cxx
 *  @brief
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: HistoryStrategy.cxx 1866 2011-04-11 10:32:27Z schueller $
 */
#include "HistoryStrategy.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Stat
    {

      /**
       * @class HistoryStrategy
       */

      CLASSNAMEINIT(HistoryStrategy);

      /* Defaultonstructor */
      HistoryStrategy::HistoryStrategy()
        : Common::TypedInterfaceObject<HistoryStrategyImplementation>(HistoryStrategyImplementation().clone())
      {
        // Nothing to do
      }

      /* Constructor with parameters */
      HistoryStrategy::HistoryStrategy(Implementation & p_implementation)
        : Common::TypedInterfaceObject<HistoryStrategyImplementation>(p_implementation)
      {
        // Nothing to do
      }

      /* Constructor with parameters */
      HistoryStrategy::HistoryStrategy(const HistoryStrategyImplementation & implementation)
        : Common::TypedInterfaceObject<HistoryStrategyImplementation>(implementation.clone())
      {
        // Nothing to do
      }

      /* Store the point according to the strategy */
      void HistoryStrategy::store(const NumericalPoint & point)
      {
        copyOnWrite();
        getImplementation()->store(point);
      }

      /* Reset the history storage through the isInitialized_ flag */
      void HistoryStrategy::reset()
      {
        getImplementation()->reset();
      }

      /* History sample accessor */
      NumericalSample HistoryStrategy::getSample() const
      {
        return getImplementation()->getSample();
      }

      /* String converter */
      String HistoryStrategy::__repr__() const
      {
        OSS oss;
        oss << "class=" << HistoryStrategy::GetClassName()
            << " implementation=" << getImplementation()->__repr__();
        return oss;
      }



    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */
