//                                               -*- C++ -*-
/**
 *  @file  SobolIndicesParameters.cxx
 *  @brief SobolIndicesParameters permits to choose which indices to compute
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2008-05-05 08:50:15 +0200 (lun, 05 mai 2008) $
 *  Id:      $Id: SobolIndicesParameters.cxx 805 2008-05-05 06:50:15Z schueller $
 */
#include <cstdlib>

#include "SobolIndicesParameters.hxx"

namespace OpenTURNS
{
  namespace Base
  {
    namespace Stat
    {

      CLASSNAMEINIT(SobolIndicesParameters);

      typedef Common::ResourceMap ResourceMap;

      const UnsignedLong SobolIndicesParameters::DefaultMaximumOrder = ResourceMap::GetAsUnsignedLong( "CorrelationAnalysis-DefaultMaximumOrder" );
      const Bool SobolIndicesParameters::DefaultTotalIndiceComputation = ResourceMap::GetAsBool( "CorrelationAnalysis-DefaultTotalIndiceComputation" );

      /* default constructor */
      SobolIndicesParameters::SobolIndicesParameters() :
        PersistentObject(),
        maximumOrder_(DefaultMaximumOrder),
        totalIndiceComputation_(DefaultTotalIndiceComputation)
      {
        // nothing to do
      }

      /* constructor with parameters */
      SobolIndicesParameters::SobolIndicesParameters(const UnsignedLong maximumOrder,
                                                     const Bool computeTotalIndice) :
        PersistentObject(),
        maximumOrder_(maximumOrder),
        totalIndiceComputation_(computeTotalIndice)
      {
        // nothing to do
      }


      /* Virtual constructor */
      SobolIndicesParameters * SobolIndicesParameters::clone() const
      {
        return new SobolIndicesParameters(*this);
      }


      /* maximum Order accessor */
      UnsignedLong SobolIndicesParameters::getMaximumOrder(void) const
      {
        return maximumOrder_;
      }

      void SobolIndicesParameters::setMaximumOrder(const UnsignedLong maximumOrder)
      {
        maximumOrder_ = maximumOrder;
      }


      /* total Indice accessor */
      Bool SobolIndicesParameters::getTotalIndiceComputation(void) const
      {
        return totalIndiceComputation_;
      }

      void SobolIndicesParameters::setTotalIndiceComputation(const Bool totalIndiceComputation)
      {
        totalIndiceComputation_ = totalIndiceComputation;
      }


      /* String converter */
      String SobolIndicesParameters::__repr__() const
      {
        OSS oss;
        oss << "class=" << SobolIndicesParameters::GetClassName()
            << " maximumOrder=" << maximumOrder_
            << " totalIndiceComputation=" << totalIndiceComputation_;
        return oss;
      }

    } // namespace Stat
  } // namespace Base
} // namespace OpenTURNS
