//                                               -*- C++ -*-
/**
 * @file  SobolIndicesParameters.hxx
 * @brief SobolIndicesParameters stores the numerical parameters of the method
 * used by CorrelationAnalysis to compute Sobol indices
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: SobolIndicesParameters.hxx 1473 2010-02-04 15:44:49Z dutka $
 */

#ifndef OPENTURNS_SOBOLINDICESPARAMETERS_HXX
#define OPENTURNS_SOBOLINDICESPARAMETERS_HXX

#include "OTprivate.hxx"
#include "NumericalSample.hxx"
#include "NumericalPoint.hxx"
#include "NumericalMathFunction.hxx"
#include "SymmetricTensor.hxx"

namespace OpenTURNS
{
  namespace Base
  {
    namespace Stat
    {

      /**
       * @class SobolIndicesParameters
       *      Used to select which indices to compute
       */
      class SobolIndicesParameters
        : public Common::PersistentObject
      {
        static const UnsignedLong DefaultMaximumOrder;
        static const Bool DefaultTotalIndiceComputation;

        CLASSNAME;
      public :
        /** default constructor */
        SobolIndicesParameters();

        /** Parameters constructor */
        SobolIndicesParameters(const UnsignedLong maximumOrder,
                               const Bool computeTotalIndice);

        /** Virtual constructor */
        virtual SobolIndicesParameters * clone() const;

        /** Maximum Order accessor */
        UnsignedLong getMaximumOrder(void) const;
        void setMaximumOrder(const UnsignedLong maximumOrder);

        /** Total Indice accessor */
        Bool getTotalIndiceComputation(void) const;
        void setTotalIndiceComputation(const Bool totalIndiceComputation);

        /** String converter */
        String __repr__() const;

      protected :
        UnsignedLong maximumOrder_;
        Bool totalIndiceComputation_;

      } ; // class SobolIndicesParameters

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_SOBOLINDICESPARAMETERS_HXX */
