//                                               -*- C++ -*-
/**
 *  @file  InverseNatafEllipticalDistributionGradient.cxx
 *  @brief Class for the InverseNataf transformation gradient for elliptical
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: InverseNatafEllipticalDistributionGradient.cxx 1866 2011-04-11 10:32:27Z schueller $
 */
#include "OTprivate.hxx"
#include "InverseNatafEllipticalDistributionGradient.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /*
       * @class InverseNatafEllipticalDistributionGradient
       *
       * This class offers an interface for the InverseNataf function for elliptical distributions
       */

      CLASSNAMEINIT(InverseNatafEllipticalDistributionGradient);

      static Base::Common::Factory<InverseNatafEllipticalDistributionGradient> RegisteredFactory("InverseNatafEllipticalDistributionGradient");

      /* Default constructor */
      InverseNatafEllipticalDistributionGradient::InverseNatafEllipticalDistributionGradient():
        ConstantNumericalMathGradientImplementation()
      {
        // Nothing to do
      }

      /* Parameter constructor */
      InverseNatafEllipticalDistributionGradient::InverseNatafEllipticalDistributionGradient(const SquareMatrix & cholesky):
        ConstantNumericalMathGradientImplementation(cholesky.transpose())
      {
        // Nothing to do
      }

      /* String converter */
      String InverseNatafEllipticalDistributionGradient::__repr__() const
      {
        return OSS() << "class=" << InverseNatafEllipticalDistributionGradient::GetClassName()
                     << " cholesky=" << getConstant().transpose();
      }

      /* Method save() stores the object through the StorageManager */
      void InverseNatafEllipticalDistributionGradient::save(StorageManager::Advocate & adv) const
      {
        ConstantNumericalMathGradientImplementation::save(adv);
      }

      /* Method load() reloads the object from the StorageManager */
      void InverseNatafEllipticalDistributionGradient::load(StorageManager::Advocate & adv)
      {
        ConstantNumericalMathGradientImplementation::load(adv);
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
