//                                               -*- C++ -*-
/**
 *  @file  InverseNatafEllipticalDistributionGradient.hxx
 *  @brief Class for the InverseNataf transformation gradient for elliptical
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: InverseNatafEllipticalDistributionGradient.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_INVERSENATAFELLIPTICALDISTRIBUTIONGRADIENT_HXX
#define OPENTURNS_INVERSENATAFELLIPTICALDISTRIBUTIONGRADIENT_HXX

#include "OTprivate.hxx"
#include "ConstantNumericalMathGradientImplementation.hxx"
#include "SquareMatrix.hxx"
#include "SymmetricTensor.hxx"
#include "StorageManager.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /**
       * @class InverseNatafEllipticalDistributionGradient
       *
       * This class offers an interface for the InverseNataf gradient for elliptical distributions
       */
      class InverseNatafEllipticalDistributionGradient
        : public Base::Func::ConstantNumericalMathGradientImplementation
      {
        CLASSNAME;
      public:

        typedef Base::Func::ConstantNumericalMathGradientImplementation ConstantNumericalMathGradientImplementation;
        typedef Base::Type::SquareMatrix                                SquareMatrix;
        typedef Base::Type::NumericalPoint                              NumericalPoint;
        typedef Base::Common::StorageManager                            StorageManager;

        /** Default constructor */
        InverseNatafEllipticalDistributionGradient();

        /** Parameter constructor */
        InverseNatafEllipticalDistributionGradient(const SquareMatrix & inverseCholesky);

        /** String converter */
        virtual String __repr__() const;

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);

      protected:


      private:

      }; /* InverseNatafEllipticalDistributionGradient */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_INVERSENATAFELLIPTICALDISTRIBUTIONGRADIENT_HXX */
