//                                               -*- C++ -*-
/**
 *  @file  NatafEllipticalDistributionHessian.cxx
 *  @brief Class for the Nataf transformation hessian for elliptical
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: NatafEllipticalDistributionHessian.cxx 1866 2011-04-11 10:32:27Z schueller $
 */
#include "OTprivate.hxx"
#include "NatafEllipticalDistributionHessian.hxx"
#include "SymmetricTensor.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /*
       * @class NatafEllipticalDistributionHessian
       *
       * This class offers an interface for the Nataf function for elliptical distributions
       */

      CLASSNAMEINIT(NatafEllipticalDistributionHessian);

      static Base::Common::Factory<NatafEllipticalDistributionHessian> RegisteredFactory("NatafEllipticalDistributionHessian");

      /* Default constructor */
      NatafEllipticalDistributionHessian::NatafEllipticalDistributionHessian():
        ConstantNumericalMathHessianImplementation()
      {
        // Nothing to do
      }

      /* Parameter constructor */
      NatafEllipticalDistributionHessian::NatafEllipticalDistributionHessian(const UnsignedLong dimension):
        ConstantNumericalMathHessianImplementation(OT::Base::Type::SymmetricTensor(dimension, dimension))
      {
        // Nothing to do
      }

      /* String converter */
      String NatafEllipticalDistributionHessian::__repr__() const
      {
        return OSS() << "class=" << NatafEllipticalDistributionHessian::GetClassName();
      }

      /* Method save() stores the object through the StorageManager */
      void NatafEllipticalDistributionHessian::save(StorageManager::Advocate & adv) const
      {
        ConstantNumericalMathHessianImplementation::save(adv);
      }

      /* Method load() reloads the object from the StorageManager */
      void NatafEllipticalDistributionHessian::load(StorageManager::Advocate & adv)
      {
        ConstantNumericalMathHessianImplementation::load(adv);
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
