//                                               -*- C++ -*-
/**
 *  @file  MediumSafe.hxx
 *  @brief Find the roots in a given direction according to the Proban
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: MediumSafe.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_MEDIUMSAFE_HXX
#define OPENTURNS_MEDIUMSAFE_HXX

#include "RootStrategyImplementation.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class MediumSafe
       */

      class MediumSafe :
        public RootStrategyImplementation
      {

        CLASSNAME;
      public:

        typedef RootStrategyImplementation::NumericalScalarCollection NumericalScalarCollection;
        typedef RootStrategyImplementation::Solver                    Solver;
        typedef RootStrategyImplementation::NumericalMathFunction     NumericalMathFunction;
        typedef RootStrategyImplementation::InternalException         InternalException;
        typedef RootStrategyImplementation::InvalidDimensionException InvalidDimensionException;

        /** Default constructor */
        explicit MediumSafe();

        /** Constructor with parameters */
        MediumSafe(const Solver & solver);

        /** Constructor with parameters */
        MediumSafe(const Solver & solver,
                   const NumericalScalar maximumDistance,
                   const NumericalScalar stepSize);


        /** Virtual constructor */
        virtual MediumSafe * clone() const;

        /** Solve gives all the roots found applying the root strategy */
        NumericalScalarCollection solve(const NumericalMathFunction & function,
                                        const NumericalScalar value);

        /** String converter */
        String __repr__() const;

      } ; /* class MediumSafe */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_MEDIUMSAFE_HXX */
