//                                               -*- C++ -*-
/**
 *  @file  RandomDirection.hxx
 *  @brief
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: RandomDirection.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_RANDOMDIRECTION_HXX
#define OPENTURNS_RANDOMDIRECTION_HXX

#include "SamplingStrategyImplementation.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class RandomDirection
       */

      class RandomDirection :
        public SamplingStrategyImplementation
      {

        CLASSNAME;

      public:

        typedef SamplingStrategyImplementation::NumericalSample NumericalSample;

        /** Default constructor */
        explicit RandomDirection();

        /** Constructor with parameters */
        explicit RandomDirection(const UnsignedLong dimension);


        /** Virtual constructor */
        virtual RandomDirection * clone() const;

        /** Generate a set of directions */
        NumericalSample generate() const;

        /** String converter */
        String __repr__() const;

      } ; /* class RandomDirection */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_RANDOMDIRECTION_HXX */
