//                                               -*- C++ -*-
/**
 *  @file  SamplingStrategyImplementation.hxx
 *  @brief
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: SamplingStrategyImplementation.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_SAMPLINGSTRATEGYIMPLEMENTATION_HXX
#define OPENTURNS_SAMPLINGSTRATEGYIMPLEMENTATION_HXX

#include "PersistentObject.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "PersistentObject.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class SamplingStrategyImplementation
       */

      class SamplingStrategyImplementation
        : public Base::Common::PersistentObject
      {

        CLASSNAME;

      public:
        typedef Base::Type::NumericalPoint  NumericalPoint;
        typedef Base::Stat::NumericalSample NumericalSample;

        /** Constructor with parameters */
        explicit SamplingStrategyImplementation(const UnsignedLong dimension);

        /** Virtual constructor */
        virtual SamplingStrategyImplementation * clone() const;

        /** Generate a set of directions */
        virtual NumericalSample generate() const;

        /** Generate a uniform random unit vector */
        NumericalPoint getUniformUnitVectorRealization(const UnsignedLong dimension) const;

        /** Generate a uniform random unit vector */
        NumericalPoint getUniformUnitVectorRealization() const;

        /** Dimension accessor */
        void setDimension(const UnsignedLong dimension);
        UnsignedLong getDimension() const;

        /** String converter */
        virtual String __repr__() const;

      protected:

        UnsignedLong dimension_;

      } ; /* class SamplingStrategyImplementation */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_SAMPLINGSTRATEGYIMPLEMENTATION_HXX */
