//                                               -*- C++ -*-
/**
 *  @file  Mvtdstpack.hxx
 *  @brief This file includes all of the mvtdstpack functions used in the platform
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: Mvtdstpack.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_MVTDSTPACK_HXX
#define OPENTURNS_MVTDSTPACK_HXX

#include "OTconfig.hxx"
#ifdef HAVE_FORTRANCINTERFACE
#  include "FortranCInterface.h"
#endif /* HAVE_FORTRANCINTERFACE */

extern "C"
{
  /** Function that evaluates n-dimensional normal CDF */
#define MVTDST_F77 F77_FUNC(mvtdst,MVTDST)
  void MVTDST_F77(int *n, int *nu, double *lower, double *upper, int *infin, double *correl, double *delta, int *maxpts, double *abseps, double *releps, double *error, double *value, int *inform);
}

#endif /* OPENTURNS_MVTDSTPACK_HXX */
