//                                               -*- C++ -*-
/**
 * @file  DistributionFactory.cxx
 * @brief Top-level class for all distribution factories
 *
 * (C) Copyright 2005-2011 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: schueller $
 * \date   $LastChangedDate: 2011-07-28 18:31:43 +0200 (Thu, 28 Jul 2011) $
 */

#include "DistributionFactory.hxx"
#include "Description.hxx"
#include "Path.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      CLASSNAMEINIT(DistributionFactory);

      /* Default constructor */
      DistributionFactory::DistributionFactory(const UnsignedLong bootstrapSize,
                                               const String & name)
        : Base::Common::TypedInterfaceObject<DistributionImplementationFactory>(new DistributionImplementationFactory(bootstrapSize, name))
      {
        // Nothing to do
      }

      /* Parameter constructor */
      DistributionFactory::DistributionFactory(const DistributionImplementationFactory & factory)
        : Base::Common::TypedInterfaceObject<DistributionImplementationFactory>(factory.clone())
      {
        // Nothing to do
      }

      /* String converter */
      String DistributionFactory::__repr__() const {
        OSS oss;
        oss << "class=" << DistributionFactory::GetClassName()
            << " implementation=" << getImplementation()->__repr__();
        return oss;
      }

      /* String converter */
      String DistributionFactory::__str__(const String & offset) const {
        return getImplementation()->__str__();
      }

      /* Here is the interface that all derived class must implement */
      Distribution DistributionFactory::build(const NumericalSample & sample) const /* throw(InvalidArgumentException, InternalException) */
      {
        return getImplementation()->build(sample);
      }

      Distribution DistributionFactory::build(const NumericalPointCollection & parameters) const /* throw(InvalidArgumentException, InternalException) */
      {
        return getImplementation()->build(parameters);
      }

      Distribution DistributionFactory::build(const NumericalPointWithDescriptionCollection & parameters) const /* throw(InvalidArgumentException, InternalException) */
      {
        return getImplementation()->build(parameters);
      }

      Distribution DistributionFactory::build() const /* throw(InvalidArgumentException, InternalException) */
      {
        return getImplementation()->build();
      }

    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
