//                                               -*- C++ -*-
/**
 *  @file  DistributionImplementationFactory.hxx
 *  @brief Top-level class for all distribution factories
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-07-28 18:31:43 +0200 (Thu, 28 Jul 2011) $
 *  Id:      $Id: DistributionImplementationFactory.hxx 2046 2011-07-28 16:31:43Z schueller $
 */
#ifndef OPENTURNS_DISTRIBUTIONIMPLEMENTATIONFACTORY_HXX
#define OPENTURNS_DISTRIBUTIONIMPLEMENTATIONFACTORY_HXX

#include "DistributionImplementation.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "CovarianceMatrix.hxx"
#include "Exception.hxx"
#include "PersistentObject.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      /**
       * @class DistributionImplementationFactory
       */
      class DistributionImplementationFactory
        : public Base::Common::PersistentObject
      {
        CLASSNAME;
      public:

        static const UnsignedLong DefaultBootstrapSize; /* = 100 */

        typedef Base::Type::NumericalPoint                                  NumericalPoint;
        typedef Base::Stat::NumericalSample                                 NumericalSample;
        typedef Base::Stat::CovarianceMatrix                                CovarianceMatrix;
        typedef Base::Common::InternalException                             InternalException;
        typedef Base::Common::InvalidArgumentException                      InvalidArgumentException;
        typedef Model::DistributionImplementation::NumericalPointCollection NumericalPointCollection;
        typedef Model::DistributionImplementation::NumericalPointWithDescriptionCollection NumericalPointWithDescriptionCollection;

        /** Default constructor */
        DistributionImplementationFactory(const UnsignedLong bootstrapSize = DefaultBootstrapSize,
                                          const String & name = OT::DefaultName);

        /** Virtual constructor */
        virtual DistributionImplementationFactory * clone() const;

        /** String converter */
        virtual String __repr__() const;

        /** String converter */
        virtual String __str__(const String & offset = "") const;

        /* Here is the interface that all derived class must implement */
        /** Build a distribution based on a sample
         * @deprecated
         * This method is deprecated. Use build() instead. */
        virtual DistributionImplementation * buildImplementation(const NumericalSample & sample) const DEPRECATED /* throw(InvalidArgumentException, InternalException) */;
        /** Build a distribution based on a sample */
        virtual DistributionImplementation * build(const NumericalSample & sample) const /* throw(InvalidArgumentException, InternalException) */;

        /** Build a distribution based on a sample and gives the covariance matrix of the estimate
         * @deprecated
         * This method is deprecated. Use build() instead. */
        virtual DistributionImplementation * buildImplementation(const NumericalSample & sample,
                                                                 CovarianceMatrix & covariance) const DEPRECATED;
        /** Build a distribution based on a sample and gives the covariance matrix of the estimate */
        virtual DistributionImplementation * build(const NumericalSample & sample,
                                                   CovarianceMatrix & covariance) const /* throw(InvalidArgumentException, InternalException) */;

        /** Build a distribution based on a set of parameters
         * @deprecated
         * This method is deprecated. Use build() instead. */
        virtual DistributionImplementation * buildImplementation(const NumericalPointCollection & parameters) const DEPRECATED /* throw(InvalidArgumentException, InternalException) */;
        /** Build a distribution based on a set of parameters */
        virtual DistributionImplementation * build(const NumericalPointCollection & parameters) const /* throw(InvalidArgumentException, InternalException) */;
        /** Build a distribution based on a set of parameters */
        virtual DistributionImplementation * build(const NumericalPointWithDescriptionCollection & parameters) const /* throw(InvalidArgumentException, InternalException) */;

        /** Build a distribution using its default constructor
         * @deprecated
         * This method is deprecated. Use build() instead. */
        virtual DistributionImplementation * buildImplementation() const DEPRECATED /* throw(InvalidArgumentException, InternalException) */;
        /** Build a distribution using its default constructor */
        virtual DistributionImplementation * build() const /* throw(InvalidArgumentException, InternalException) */;

        /** Bootstrap size accessor */
        UnsignedLong getBootstrapSize() const;
        void setBootstrapSize(const UnsignedLong bootstrapSize);

      protected:
        /* Execute a R script */
        virtual NumericalPoint runRFactory(const NumericalSample & sample,
                                           const DistributionImplementation & distribution) const
          /* throw(InvalidArgumentException, InternalException) */;

        /* Number of bootstrap resampling for ovariance estimation */
        UnsignedLong bootstrapSize_;

      private:
        /* Convert a parameters collection into a NumericalPoint */
        static NumericalPoint ParametersAsNumericalPoint(const NumericalPointWithDescriptionCollection & parametersCollection);

      }; /* class DistributionImplementationFactory */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_DISTRIBUTIONIMPLEMENTATIONFACTORY_HXX */
