//                                               -*- C++ -*-
/**
 *  @file  UsualDistribution.cxx
 *  @brief Abstract top-level class for all standard distributions
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: UsualDistribution.cxx 1866 2011-04-11 10:32:27Z schueller $
 */
#include "UsualDistribution.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      CLASSNAMEINIT(UsualDistribution);

      /* Default constructor */
      UsualDistribution::UsualDistribution(const String & name)
        : DistributionImplementation(name)
      {
        // Nothing to do
      }

      /* Virtual constructor */
      UsualDistribution * UsualDistribution::clone() const
      {
        return new UsualDistribution(*this);
      }

      /* String converter */
      String UsualDistribution::__repr__() const {
        OSS oss;
        oss << "class=" << UsualDistribution::GetClassName();
        return oss;
      }

      /* Tell if the distribution is elliptical */
      Bool UsualDistribution::isElliptical() const
      {
        return false;
      }

      /* Tell if the distribution is continuous */
      Bool UsualDistribution::isContinuous() const
      {
        return false;
      }




    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
