//                                               -*- C++ -*-
/**
 *  @file  UsualDistribution.hxx
 *  @brief Abstract top-level class for all standard distributions
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: UsualDistribution.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_USUALDISTRIBUTION_HXX
#define OPENTURNS_USUALDISTRIBUTION_HXX

#include "OTprivate.hxx"
#include "DistributionImplementation.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {


      /**
       * @class UsualDistribution
       *
       * All traditionnal distribution inherits from this class.
       * Classes derived from UsualDistribution are known by themselves,
       * without being reconstructed or built in any way.
       */
      class UsualDistribution
        : public DistributionImplementation
      {
        CLASSNAME;
      public:

        typedef DistributionImplementation::Implementation            Implementation;
        typedef DistributionImplementation::InvalidArgumentException  InvalidArgumentException;
        typedef DistributionImplementation::InvalidDimensionException InvalidDimensionException;
        typedef DistributionImplementation::InternalException         InternalException;
        typedef DistributionImplementation::NotDefinedException       NotDefinedException;
        typedef DistributionImplementation::NumericalPoint            NumericalPoint;
        typedef DistributionImplementation::NumericalSample           NumericalSample;
        typedef DistributionImplementation::CovarianceMatrix          CovarianceMatrix;
        typedef DistributionImplementation::Indices                   Indices;
        typedef DistributionImplementation::IsoProbabilisticTransformation        IsoProbabilisticTransformation;
        typedef DistributionImplementation::InverseIsoProbabilisticTransformation InverseIsoProbabilisticTransformation;
        typedef DistributionImplementation::NumericalPointCollection  NumericalPointCollection;
        typedef DistributionImplementation::NumericalPointWithDescriptionCollection  NumericalPointWithDescriptionCollection;

        /** Default constructor */
        explicit UsualDistribution(const String & name = OT::DefaultName);


        /** Virtual constructor */
        virtual UsualDistribution * clone() const;

        /** String converter */
        String __repr__() const;



        /* Here is the interface that all derived class must implement */

        /** Tell if the distribution is elliptical */
        virtual Bool isElliptical() const;

        /** Tell if the distribution is continuous */
        virtual Bool isContinuous() const;



      protected:


      private:

      }; /* class UsualDistribution */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_USUALDISTRIBUTION_HXX */
